#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_cms()
{
    log_info "begin cms Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old cms"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new cms"
    old_version_data_file="${LINE_ROOT}/old_version_data.tar.gz"
    check_tar_file_before_unzip "${old_version_data_file}"
    CHECK_RESULT $? "Check old_version_data.tar.gz failed."
    tar -P --extract --file="${old_version_data_file}" /opt/huawei/dj/etc/cms/cms.conf
    CHECK_RESULT $? "failed to restore conf new cms"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new cms"
    sh "${CURRENT_PATH}/post_start.sh" upgrade
    CHECK_RESULT $? "failed to post start"
    log_info "Finish cms Upgrade action."
}

log_info "begin cms Upgrade."
upgrade_cms
touch "${CURRENT_PATH}/cms_upgrade_finish"
log_info "Upgrade cms success."