#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="gaussdb_helper"
GAUSSDB_FLOAT_IP=$(get_info gaussdb_float_ip)
IP_VERSION=$(get_info ip_version)
#******************************************************************#
# Function: set_floatip
# Description: The function to set floatIP
# Input Parameters:
# None
# Return : 0 success
#      1 failed
#******************************************************************#
function set_floatip()
{
    if ip addr | grep "\ ${GAUSSDB_FLOAT_IP}/";then
        log_warn "${GAUSSDB_FLOAT_IP} has been set."
        return 0
    fi
    if [[ "${IP_VERSION}" == "ipv6" ]];then
        ping6 -c 3 "${GAUSSDB_FLOAT_IP}";ret_code=$?
    else
        ping -c 3 "${GAUSSDB_FLOAT_IP}";ret_code=$?
    fi
    if [[ "${ret_code}" -eq 0 ]];then
        log_warn "${GAUSSDB_FLOAT_IP} has been used somewhere,please check whether if the ip is available "
        return 0
    fi

    if ! (sudo /opt/huawei/root_tools/omm-ha/update_ip_conf.sh add gaussdb);then
        log_error "Set ${GAUSSDB_FLOAT_IP} failed."
        return 1
    fi
    log_info "${GAUSSDB_FLOAT_IP} has been set."
    return 0
}

#******************************************************************#
# Function: unset_floatip
# Description: The function to unset floatIP
# Input Parameters:
# None
# Return : 0 success
#      1 failed
#******************************************************************#
function unset_floatip()
{
    if ! (ip addr | grep "\ ${GAUSSDB_FLOAT_IP}/");then
        log_warn "${GAUSSDB_FLOAT_IP} is not exist."
        return 0
    fi
    sudo /opt/huawei/root_tools/omm-ha/update_ip_conf.sh del gaussdb
    log_info "${GAUSSDB_FLOAT_IP} has been unset."
    return 0

}

#******************************************************************#
# Function: status
# Description: The function to query the status of floatIP
# Input Parameters:
# None
# Return : 0 running
#      2 stopped
#******************************************************************#
function status()
{
    if ! (ip addr | grep "\ ${GAUSSDB_FLOAT_IP}/");then
        log_info "${GAUSSDB_FLOAT_IP} is stopped."
        return 2
    fi
    log_info "${GAUSSDB_FLOAT_IP} is running."
    return 0
}


#******************************************************************#
# Function: main
# Description: main
# Input Parameters:action
# Return : 0 double mode
#exit code:
# single / active-active
#   0 = normal
#   1 = abnormal
#   2 = stop
#   3 = unknown
#   4 = starting
#   5 = stopping
#   10 = invalid action
#
# active-standby
#   1 = abnormal
#   2 = stop
#   3 = unknown
#   6 = active normal
#   7 = standby normal
#   8 = switching to active
#   9 = switching to standby
#   10 = invalid action
#******************************************************************#
function main ()
{
    case $1 in
    status)
        status >> /dev/null 2>&1
        exit $?
        ;;
    start)
        set_floatip >> /dev/null 2>&1
        exit $?
        ;;
    stop)
        unset_floatip >> /dev/null 2>&1
        exit 0
        ;;
    force-stop)
        unset_floatip >> /dev/null 2>&1
        exit 0
        ;;
    *)
        log_warn "Operation($1) not support."
        exit 10
        ;;
    esac
}
main "$1"
