#!/bin/bash
source /opt/huawei/dj/inst/utils.sh
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
CHECK_RESULT_FILE="${CURRENT_PATH}/toolkit_check_inspect_out.xml"
# **************************************************************************** #
# Function Name: WriteResultHeaderToXml
# Description: Write Fixed Format Header To The Result File
# Parameter:
# Return:
# **************************************************************************** #
function WriteResultHeaderToXml()
{
    {
        echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
        echo "<device>"
        echo "  <cmditem id=\"$1\">"
    } >> "${CHECK_RESULT_FILE}"
}
# **************************************************************************** #
# Function Name: WriteErrorItemResultToXml
# Description: Write Fixed Error Format To The Result File
# Parameter:
# Return:
# **************************************************************************** #
function WriteErrorItemResultToXml()
{
    {
        echo "      <item id=\"$1\">"
        echo "          <errorvalue type=\"$2\">$3</errorvalue>"
        echo "          <judge>$4</judge>"
        echo "      </item>"
    } >> "${CHECK_RESULT_FILE}"
}
# **************************************************************************** #
# Function Name: WriteNormalItemResultToXml
# Description: Write Fixed Normal Format To The Result File
# Parameter:            
# Return:
# **************************************************************************** #
function WriteNormalItemResultToXml()
{
    {
        echo "      <item id=\"$1\">"
        echo "          <commonvalue type=\"$2\">$3</commonvalue>"
        echo "          <judge>0</judge>"
        echo "      </item>"
    } >> "${CHECK_RESULT_FILE}"
}
# **************************************************************************** #
# Function Name: WriteNormalItemResultToXml
# Description: Write Fixed Format End To The Result File
# Parameter:            
# Return:
# **************************************************************************** #
function WriteResultEndToXml()
{   
    {
        echo "  </cmditem>"
        echo "</device>"
    } >> "${CHECK_RESULT_FILE}"
}
# **************************************************************************** #
# Function Name: IsProcessExist
# Description: IsProcessExist
# Parameter: $1 进程名称, $2 输出到报告中的进程名称, $3巡检脚本名称
# Return: 进程的个数
# **************************************************************************** #
function IsProcessExist()
{
    item=$1
    processNameShort=$2
    service_name=$3
    if bash "/opt/huawei/dj/tools/${service_name}/inspect.sh" "${item}"  >/dev/null 2>&1;then
        echo "${processNameShort}:Exist"
        return 0
    else
        echo "${processNameShort}:Not Exist"
        return 1
    fi
}
# **************************************************************************** #
# Function Name: check
# Description: 组件检查
# Parameter: $1 进程名称, $2 输出到报告中的进程名称 , $3巡检脚本名称
# Return: 进程的个数
# **************************************************************************** #
function check()
{
    ret=0
    while [[ $# -ne 0 ]];do
        tip=$(IsProcessExist "$1" "$2" "$3");ret=$((ret+$?))
        msg="${msg}||${tip}"
        shift;shift;shift
    done
    if [[ "${msg:0:2}" == '||' ]];then
        msg=${msg:2}
    fi
    echo "${msg}"
    return ${ret}
}
# **************************************************************************** #
# Function Name: check_logon
# Description: 节点状态检查
# Parameter: $1 节点IP
# Return: 进程的个数
# **************************************************************************** #
function check_logon()
{
    cmd_manager --node_ip "$1" --cmd "/opt/huawei/dj/tools/inspect/showsys.sh" >/dev/null 2>&1
    return $?
}