#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="karbor-run"
HOST_IP=$(get_info manage_ip)

function args_err()
{
    echo -e "karbor-${component}Control: illegal option"
    showhelp
}

function showhelp()
{
    usage="Usage: karbor-${component}Control "
    len=${#usage}
    echo "Usage: karbor-${component}Control [-S RUN]"
    printf "%-${len}s[-S STOP]\n"
    printf "%-${len}s[-A RESTART]\n"
    printf "%-${len}s[-CS ComponentState]\n"
    printf "%-${len}s[-h]\n"
    exit 1
}

function get_component_name()
{
    export CSBS_PYTHON_DATA="$$"
    (
        echo "import os"
        echo "import psutil"
        echo "try:"
        echo "    pid = int(os.getenv('CSBS_PYTHON_DATA'))"
        echo "    pro = psutil.Process(pid)"
        echo "    while pro.pid:"
        echo "        cmdline = pro.cmdline()"
        echo "        if '/opt/huawei/dj/sbin/karbor-apiControl' in cmdline:"
        echo "            print('api')"
        echo "            exit(0)"
        echo "        if '/opt/huawei/dj/sbin/karbor-protectionControl' in cmdline:"
        echo "            print('protection')"
        echo "            exit(0)"
        echo "        if '/opt/huawei/dj/sbin/karbor-operationControl' in cmdline:"
        echo "            print('operation')"
        echo "            exit(0)"
        echo "        pro = pro.parent()"
        echo "    exit(1)"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}

function start_heartbeat_and_register_haproxy()
{
    if [[ "${component}" == "api" ]];then
        haproxy_regist add --frontend-name karbor --plane internal --frontend-port 8799 \
        --server-ip "${HOST_IP}" --server-port 28799 >/dev/null 2>&1
        echo_info "Finish register ${HOST_IP}:28799, return_code:$?"
    fi
    echo_info "$(heartBeat START "karbor-${component}")"
}

function component_run()
{
    echo_info "Run karbor${component} begin"
    componentCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/kangaroo-${component}")
    if [[ -n "${componentCmd}" ]]; then
        start_heartbeat_and_register_haproxy
        echo_info "start karbor${component} successfully."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        proc_manager --filename "kangaroo-${component}"
        sleep 10
        componentCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/kangaroo-${component}")
        if [[ -z "${componentCmd}" ]]; then
            log_warn "karbor${component} process is not running when start, retry."
            continue
        fi
        start_heartbeat_and_register_haproxy
        echo_info "start karbor${component} successfully."
        return 0
    done
    ECHO_RETURN 1 "start karbor${component} failed."
}

function stop_heartbeat_and_unregister_haproxy()
{
    echo_info "$(heartBeat STOP "karbor-${component}")"
    if [[ "${component}" == "api" ]];then
        haproxy_regist delete --frontend-name karbor --plane internal --frontend-port 8799 \
        --backend-name default --server-ip "${HOST_IP}" --server-port 28799 >/dev/null 2>&1
        echo_info "Finish unregister ${HOST_IP}:28799, return_code:$?"
    fi
}

function component_stop()
{
    echo_info "Stop karbor${component} begin"
    componentCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/kangaroo-${component}")
    if [[ -z "${componentCmd}" ]]; then
        stop_heartbeat_and_unregister_haproxy
        echo_info "karbor${component} process is not running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        kill_process "/opt/huawei/dj/sbin/kangaroo-${component}"
        sleep 5
        componentCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/kangaroo-${component}")
        if [[ -n "${componentCmd}" ]]; then
            log_warn "karbor${component} process is running when stop, retry."
            continue
        fi
        stop_heartbeat_and_unregister_haproxy
        echo_info "stop karbor${component} process successfully."
        return 0
    done
    ECHO_RETURN 1 "stop karbor${component} failed."
}

function component_restart()
{
    echo_info "${component} restart begin."
    component_stop
    sleep 5
    component_run
    echo_info "${component} restart end."
}

function component_statusget()
{
    componentCmd=$(pgrep -U 51001 -f "/opt/huawei/dj/sbin/kangaroo-${component}")
    if [[ -z "${componentCmd}" ]]; then
        ECHO_RETURN 1 "karbor-${component} process is not running."
    fi
    if [[ "${component}" == "api" ]];then
        curl -i -k "https://${HOST_IP}:28799" >/dev/null 2>&1
        ECHO_RETURN $? "karbor-${component} port 28799 unreachable ."
    fi
    echo_info "karbor-${component} process is running."
    exit 0
}

component=$(get_component_name)
if [[  -z "${component}" ]];then
    ECHO_RETURN $? "get component name failed."
fi
case "$1 '$2' $#" in
    "-S 'RUN' 2")
        Action1=$2
        ;;
    "-S 'STOP' 2")
        Action1=$2
        ;;
    "-A 'RESTART' 2")
        Action2=$2
        ;;
    "-CS 'ComponentState' 2")
        Action3=$2
        ;;
    "-h '' 1")
        showhelp
        ;;
    *)
        args_err
        ;;
esac
if [[ "ComponentState" == "${Action3}" ]]; then
    component_statusget
elif [[ "RESTART" == "${Action2}" ]]; then
    component_restart
elif [[ "RUN" == "${Action1}" ]]; then
    component_run
elif [[ "STOP" == "${Action1}" ]]; then
    component_stop
fi
exit 0