#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo "$(readlink -f "$0")" "$@";exit $?
fi
# 外部输入参数使用前需要校验
# 参数1为add、del之一
# 参数2为haproxy、gaussdb之一
[[ $# -ne 2 ]] && exit 1
OPERATION="$1"
TARGET_NAME="$2"
if [[ "${TARGET_NAME}" == "haproxy" ]];then
    TARGET_ADDR="HAPROXY_FLOAT_IP"
elif [[ "${TARGET_NAME}" == "gaussdb" ]];then
    TARGET_ADDR="GAUSSDB_FLOAT_IP"
else
    exit 2
fi

# 从openstack用户获取节点网络使用前需要校验:预期IP格式
source /opt/huawei/root_tools/base/root_utils.sh
check_ip "${TARGET_ADDR}" || exit 3

# 限定操作网卡eth0
NET_MASK=$(ip addr show eth0 | grep eth0 | grep inet | head -n 1  | awk '{print $2}'| awk -F'/' '{print $2}')
if [[ "${OPERATION}" == "add" ]];then
    ip addr add "${TARGET_ADDR}/${NET_MASK}" dev eth0 label "eth0:${TARGET_NAME}" > /dev/null 2>&1
elif [[ "${OPERATION}" == "del" ]];then
    ip addr del "${TARGET_ADDR}/${NET_MASK}" dev eth0 > /dev/null 2>&1
else
    exit 6
fi