#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="DJServiceControl"
CONTROL_PARA="$1"
# 有服务数量的改动时，需修改stop_service 的 service_cnt, service_cnt 数量为len(SERVICE_LIST) -1
SERVICE_LIST=("omm-ha" "zookeeper" "alarm" "cps-monitor" "cms" "scagent" "rabbitmq" "haproxy"
"karbor-api" "karbor-protection" "karbor-operation" "resource_manager")

if [[ $# -ne 1 ]]; then
    echo "Usage: DJserviceControl [stop] [start] [restart]"
    exit 1
fi

function restart_service()
{
    echo_info "begin restart backup service..."
    for service in "${SERVICE_LIST[@]}";do
        if [[ ! -L "/opt/huawei/dj/sbin/${service}Control" ]];then
            continue
        fi
        cmd_retry "${service}Control -A RESTART" 60 5
        if [[ "$?" -ne 0 ]]; then
            echo_error "restart ${service} failed!"
        else
            echo_info "restart ${service} success."
        fi
    done
    echo_info "restart backup service finish."
}

function start_service()
{
    echo_info "begin start backup service..."
    for service in "${SERVICE_LIST[@]}";do
        if [[ ! -L "/opt/huawei/dj/sbin/${service}Control" ]];then
            continue
        fi
        cmd_retry "${service}Control -S RUN" 60 5
        if [[ "$?" -ne 0 ]]; then
            echo_error "start ${service} failed!"
        else
            echo_info "start ${service} success."
        fi
    done
    echo_info "start backup service finish."
}

function stop_service()
{
    echo_info "begin stop backup service..."
    service_cnt=11
    for index in $(seq "${service_cnt}" -1 0);do
        service="${SERVICE_LIST[${index}]}"
        if [[ ! -L "/opt/huawei/dj/sbin/${service}Control" ]];then
            continue
        fi
        cmd_retry "${service}Control -S STOP" 60 5
        ECHO_RETURN $? "stop ${service} failed!"
        echo_info "stop ${service} success."
    done
    echo_info "stop backup service finish."
}

#################################################### main ####################
uptime=$(awk '{print $1}' /proc/uptime)
uptime_second=${uptime%.*}
if [ -n "${uptime_second}" ] && [ "${uptime_second}" -lt "40" ];then
    sleep 30
    echo_info "========System new reboot here======="
fi
if [[ "${CONTROL_PARA}" == "restart" ]];then
    restart_service
    sudo /opt/huawei/root_tools/base/modify_iptables_conf.sh
elif [[ "${CONTROL_PARA}" == "start" ]];then
    start_service
    sudo /opt/huawei/root_tools/base/modify_iptables_conf.sh
elif [[ "$1" == "stop" ]];then
    stop_service
fi
exit 0