#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function stop_service()
{
    sudo -u openstack /opt/huawei/dj/sbin/DJserviceControl stop
    chkconfig --del DJControl
    kill_process /opt/huawei/dj
}

function uninstall_user()
{
    userdel -rf djmanager
    userdel -rf openstack
    groupdel openstack
    sed -i "/djmanager/d" /etc/ssh/sshd_config
    sed -i "s/PermitRootLogin no/PermitRootLogin yes/g"  /etc/ssh/sshd_config
    service sshd restart
}

function uninstall_file()
{
    rm -rf /etc/sudoers.d/sudo_*_conf
    rm -rf /etc/cron.d/crontab_*.conf
    rm -rf /etc/init.d/DJControl
    rm -rf /var/log/huawei/dj
    rm -rf /opt/huawei/{djbackup,djcollect,dj,root_tools}
}

stop_service >/dev/null 2>&1
uninstall_file >/dev/null 2>&1
uninstall_user >/dev/null 2>&1
exit 0