#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="modify_pwd"

db_user_name=$1
if [[ "${db_user_name}" != "cms_a" ]] && [[ "${db_user_name}" != "cms_b" ]];then
    CHECK_RESULT 1 "Update cms db account config file failed."
fi

read -rs db_user_password
echo "${db_user_password}" | xargs | grep -E "^[A-F0-9#]+$">/dev/null
CHECK_RESULT $? "Incorrect account. Please try again."

db_float_ip=$(get_info gaussdb_float_ip)
db_ca_file=$(get_info db_ca_file)
config_file="/opt/huawei/dj/etc/cms/cms.conf"
connection="connection = postgresql+psycopg2://${db_user_name}:${db_user_password}@[${db_float_ip}]:5432/cms?sslrootcert=${db_ca_file}\&sslmode=verify-ca"
sed -i "s%connection.*%${connection}%g" ${config_file}
CHECK_RESULT $? "Update cms db password config file failed."

cmsControl -A RESTART
CHECK_RESULT $? "Restart cms service failed"
log_info "Update cms config file finished."
exit 0