#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init cps-monitor rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/cps-monitor
    log_info "Finish cps-monitor rsyslog configuration."
}

function install_script()
{
    log_info "Init cps-monitor script configuration."
    cps_monitor_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "cps_monitor*.whl")
    csbs_python -m pip install --no-deps --force-reinstall  "${cps_monitor_whl}"
    CHECK_RESULT $? "pip install cps_monitor_whl failed."
    log_info "Finish cps-monitor script configuration."
}

function install_tools()
{
    log_info "Init cps-monitor tools configuration."
    mkdir -p /opt/huawei/dj/tools/cps-monitor
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/cps-monitor
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/cps-monitor/cps-monitorControl.sh
    log_info "Finish cps-monitor tools configuration."
}

function install_conf()
{
    log_info "Init cps-monitor conf configuration."
    log_info "Finish cps-monitor conf configuration."
}

function install_version()
{
    log_info "Init cps-monitor version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/cps-monitor.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy cps-monitor version Failed."
    log_info "Finish cps-monitor version configuration."
}

function install_crontab()
{
    log_info "Init cps-monitor crontab configuration."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/crontab_cps_monitor.conf" /etc/cron.d/
    CHECK_RESULT $? "Copy crontab_cps_monitor failed."
    cmd_retry "service cron restart" 60 5
    CHECK_RESULT $? "Restart cron failed."
    log_info "Finish cps-monitor crontab configuration."
}

function install_permission()
{
    log_info "Init cps-monitor permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/etc/cps-monitor/cps_mon.share
    set_modify_permission /var/log/huawei/dj
    log_info "Finish cps-monitor permission configuration."
}

function install_root()
{
    log_info "Init cps-monitor root configuration."
    install_sudo_conf "${CURRENT_PATH}/conf/sudo_cps_monitor_conf"
    install_root_tools cps-monitor "${CURRENT_PATH}/root_sudo/update_date_conf.sh"
    install_root_tools cps-monitor "${CURRENT_PATH}/root_sudo/update_dns_conf.sh"
    install_root_tools cps-monitor "${CURRENT_PATH}/root_sudo/update_ntp_conf.sh"
    log_info "Finish cps-monitor root configuration."
}

log_info "Start cps-monitor installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish cps-monitor installation."
