#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="log_monitor"
LOG_FILE_LIST=""
check_file=$(find /var/log -type f -name "*.log" -size "+100M")
while IFS= read -r file;do
    [[ -n "${file}" ]] && LOG_FILE_LIST="${LOG_FILE_LIST}$(basename "${file}");"
done <<< "${check_file}"
if [[ -z "${LOG_FILE_LIST}" ]]; then
    clear_alarm 1020765
    CHECK_RESULT $? "Failed to clear the alarm indicating that the log size exceeds the threshold."
    log_info "The alarm indicating that the log size exceeds the threshold is cleared."
else
    log_info "Size threshold-crossing logs:${LOG_FILE_LIST}"
    send_alarm 1020765 "{\"Log File Name\": \"${LOG_FILE_LIST}\"}"
    CHECK_RESULT $? "Sending Failure Log Size Exceeds the Threshold."
    log_info "The alarm indicating that the number of logs exceeds the threshold is successfully sent."
fi