#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

log_info "Start change  gaussdb config."
local_ip=$(get_info local_ip)
peer_node=$(get_info db_peer_node)
float_ip=$(get_info gaussdb_float_ip)
pg_hba_file='/opt/huawei/dj/bin/gaussdb/data/pg_hba.conf'
postgresql_conf='/opt/huawei/dj/bin/gaussdb/data/postgresql.conf'
sed -i "/^local.*all.*all/d" ${pg_hba_file}
sed -i "/^host.*all.*all/d" ${pg_hba_file}
echo "local    all             all                                   sha256" >> ${pg_hba_file}
IFS="," read -r -a cluster_ips <<< "$(get_info manage_ip_list)"
for node in "${cluster_ips[@]}";do
  echo "hostssl  all             all             ${node}/32            sha256" >> ${pg_hba_file}
done
sed -i "s/^listen_addresses.*/listen_addresses='${float_ip}'/g" ${postgresql_conf}
replconninfo="localhost=${local_ip} localport=12211 remotehost=${peer_node} remoteport=12211"
sed -i "/replconninfo1/ c replconninfo1 = '${replconninfo}'" ${postgresql_conf}
sed -i "/repl_force_cert_check/d"  ${postgresql_conf}
echo "repl_force_cert_check = 'repl1_peer_cn=${float_ip}'" >> ${postgresql_conf}
sudo -u openstack bash /opt/huawei/dj/tools/gaussdb/sync_monitor.sh reset_status
log_info "Finish change gaussdb config."
