#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_gaussdb()
{
    if [[ "$(get_db_role)" == "Primary" ]];then # 本端降备，对端升主
        cmd_manager --node_ip "$(get_info manage_ip)" --cmd "swap-service" --service "omm-ha"
        sleep 10
    fi
    log_info "begin gaussdb Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old gaussdb"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new gaussdb"
    sh "${CURRENT_PATH}/config.sh"
    CHECK_RESULT $? "failed to config new gaussdb"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new gaussdb"
    log_info "Finish gaussdb Upgrade action."
}

log_info "begin gaussdb Upgrade."
upgrade_gaussdb
touch "${CURRENT_PATH}/gaussdb_upgrade_finish"
log_info "Upgrade gaussdb success."