#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init resource_manager rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/resource_manager
    log_info "Finish resource_manager rsyslog configuration."
}

function install_script()
{
    log_info "Init resource_manager script configuration."
    resource_manager_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "resource_manager*.whl")
    csbs_python -m pip install --no-deps --force-reinstall "${resource_manager_whl}"
    CHECK_RESULT $? "pip install resource_manager failed."
    log_info "Finish resource_manager script configuration."
}

function install_tools()
{
    log_info "Init resource_manager tools configuration."
    mkdir -p /opt/huawei/dj/{tools,etc,bin}/resource_manager
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/resource_manager
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/resource_manager/resource_managerControl.sh
    log_info "Finish resource_manager tools configuration."
}

function install_version()
{
    log_info "Init resource_manager version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/resource_manager.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy resource_manager version Failed."
    log_info "Finish resource_manager version configuration."
}

function install_permission()
{
    log_info "Init resource_manager permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/etc/resource_manager/resource_manager.conf
    log_info "Finish resource_manager permission configuration."
}

function install_root()
{
    log_info "Init resource_manager root configuration."
    log_info "Finish resource_manager root configuration."
}


function install_conf()
{
    log_info "Init resource_manager conf configuration."
    log_info "Finish resource_manager conf configuration."
}

function install_crontab()
{
    log_info "Init resource_manager crontab configuration."
    log_info "Finish resource_manager crontab configuration."
}

log_info "Start resource_manager installation."
install_rsyslog
install_script
install_root
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish resource_manager installation."
