#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"


function upgrade_resource_manager()
{
    log_info "begin resource_manager Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old resource_manager"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new resource_manager"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new resource_manager"
    log_info "Finish resource_manager Upgrade action."
}

log_info "begin resource_manager Upgrade."
upgrade_resource_manager
touch "${CURRENT_PATH}/resource_manager_upgrade_finish"
log_info "Upgrade resource_manager success."