#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="unify_passwd"
SSH_OPT="-o StrictHostKeyChecking=no -o ConnectTimeout=5"

function read_password()
{
    read -rs password
    if ! decrypt_pwd "${password}";then
        exit 11
    fi
}

function check_djmanager_pwd()
{
    current_pwd=$(get_safe_password "$(read_password)")
    host_ip=$(get_info manage_ip)
    /usr/bin/expect <<-EOF
    set timeout 5
    spawn ssh ${SSH_OPT} djmanager@${host_ip}
    expect {
        "*authentication failures" {exit 12}
        "*locked*" {exit 13}
        "expired" {exit 14}
        "*assword*" {
            send "${current_pwd}\r"
            exp_continue
        }
        "djmanager@karbor" {exit 0}
        eof { }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function check_root_pwd()
{
    current_pwd=$(get_safe_password "$(read_password)")
    /usr/bin/expect <<-EOF
    set timeout 5
    spawn sudo su root
    expect {
        "*incorrect" {exit 12}
        "*Sorry" {exit 12}
        "*locked*" {exit 13}
        "expired" {exit 14}
        "*assword*" {
            send "${current_pwd}\r"
            exp_continue
        }
        "root@karbor" {exit 0}
        eof { }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function modify_djmanager_pwd()
{
    target_pwd=$(get_safe_password "$(read_password)")
    current_pwd=$(get_safe_password "$(read_password)")
    host_ip=$(get_info manage_ip)
    /usr/bin/expect <<-EOF
    set timeout 5
    spawn ssh ${SSH_OPT} djmanager@${host_ip}
    expect {
        "*authentication failures" {exit 12}
        "*locked*" {exit 13}
        "expired" {exit 14}
        "*assword*" {
            send "${current_pwd}\r"
            exp_continue
        }
        "djmanager@karbor" {send "passwd\r"}
    }
    expect {
        "Current password:" {send "${current_pwd}\r"}
    }
    expect {
        "(current) UNIX password:" {send "${current_pwd}\r"}
    }
    expect {
        "New password:" {send "${target_pwd}\r"}
    }
    expect {
        "BAD PASSWORD: The password is the same as the old one" {exit 25}
        "BAD PASSWORD: The password contains less than 3 character classes" {exit 24}
        "BAD PASSWORD: The password is shorter than 8 characters" {exit 23}
        "BAD PASSWORD: The password fails the dictionary check" {exit 22}
        "Retype new password:" {send "${target_pwd}\r"}
    }
    expect {
        "Password has been already used. Choose another." {exit 21}
        "passwd: Have exhausted maximum number of retries for service" {exit 20}
        "passwd: all authentication tokens updated successfully" {exit 0}
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function modify_root_pwd()
{
    target_pwd=$(get_safe_password "$(read_password)")
    current_pwd=$(get_safe_password "$(read_password)")
    /usr/bin/expect<<-EOF
    set timeout 5
    spawn sudo su root
    expect {
        "*incorrect" {exit 12}
        "*Sorry" {exit 12}
        "*locked*" {exit 13}
        "expired" {exit 14}
        "*assword*" {
            send "${current_pwd}\r"
            exp_continue
        }
        "root@karbor" {send "passwd\r"}
    }
    expect {
        "New password:" {send "${target_pwd}\r"}
    }
    expect {
        "BAD PASSWORD: The password is the same as the old one" {exit 25}
        "BAD PASSWORD: The password contains less than 3 character classes" {exit 24}
        "BAD PASSWORD: The password is shorter than 8 characters" {exit 23}
        "BAD PASSWORD: The password fails the dictionary check" {exit 22}
        "Retype new password:" {send "${target_pwd}\r"}
    }
    expect {
        "Password has been already used. Choose another." {exit 21}
        "passwd: Have exhausted maximum number of retries for service" {exit 20}
        "passwd: all authentication tokens updated successfully" {exit 0}
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

# 支持用户djmanager和root密码check和modify操作
if [[ $# -ne 2 ]];then
    CHECK_RESULT 1 "The parameter is [$*], Incorrect quantity."
fi

CUR_OPER=$1
USER_NAME=$2
if [[ "${USER_NAME}" == "djmanager" ]] && [[ "${CUR_OPER}" == "check" ]]; then
    check_djmanager_pwd;ret_code=$?
elif [[ "${USER_NAME}" == "root" ]] && [[ "${CUR_OPER}" == "check" ]]; then
    check_root_pwd;ret_code=$?
elif [[ "${USER_NAME}" == "djmanager" ]] && [[ "${CUR_OPER}" == "modify" ]]; then
    modify_djmanager_pwd;ret_code=$?
elif [[ "${USER_NAME}" == "root" ]] && [[ "${CUR_OPER}" == "modify" ]]; then
    modify_root_pwd;ret_code=$?
else
    CHECK_RESULT 15 "[${CUR_OPER}] [${USER_NAME}] not supported "
fi
CHECK_RESULT ${ret_code} "${CUR_OPER} ${USER_NAME} failed. ret code is [${ret_code}]."
log_info "${CUR_OPER} ${USER_NAME} successful."
