#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

ARB_SOURCE_CA_PATH="/home/djmanager/ca.crt"
ARB_DEST_CA_PATH="/home/openstack/ca.crt"

function start_upgrade()
{
    log_info "begin upgrade backup service."
    # 为了解决docker版本升级到去docker版本root帐户锁定问题，升级前增加指定脚本提权
    if [[ -f "/opt/huawei/root_tools/base/exec_docker_action.sh" ]];then
        echo "openstack ALL = (root) NOPASSWD:/opt/huawei/root_tools/base/exec_docker_action.sh" >> ${LINE_ROOT}/services/base/conf/sudo_base_conf
    fi
    cps-monitorControl -S STOP
    if [[ ! -f "${LINE_ROOT}/old_version_data.tar.gz" ]];then
        tar -P -czf "${LINE_ROOT}/old_version_data.tar.gz" /opt/huawei/dj /opt/huawei/root_tools /etc/sudoers.d  /etc/cron.d
    fi
    if [[ ! -f "${LINE_ROOT}/upgrade_files.tar.gz" ]];then
        run_tar_upgrade_files_cmd="tar -P -czf ${LINE_ROOT}/upgrade_files.tar.gz $(cat "${LINE_ROOT}/cfg/upgrade_files.conf")"
        ${run_tar_upgrade_files_cmd}
    fi
    return 0
}

function stop_upgrade()
{
    docker ps -a | grep -v "CONTAINER ID" | awk '{print $1}' | xargs docker rm -f
    DJserviceControl restart
    while read -r upgrade_file;do
        [[ -n "${upgrade_file}" ]] && rm -rf "${upgrade_file}"
    done < "${LINE_ROOT}/cfg/upgrade_files.conf"

    # 同步仲裁证书
    if [[ -f "${ARB_SOURCE_CA_PATH}" ]];then
        log_info "Begin to sync arb cert."
        cp -f ${ARB_SOURCE_CA_PATH} ${ARB_DEST_CA_PATH}
        chown -h openstack:openstack "${ARB_DEST_CA_PATH}"
        sync_karbor_certs --arb ${ARB_DEST_CA_PATH}
        CHECK_RESULT $? "Failed to sync arb ca cert."
    fi
    # 为了解决docker版本升级到去docker版本root帐户锁定问题，升级后移除docker相关脚本
    if [[ -f "/opt/huawei/root_tools/base/exec_docker_action.sh" ]];then
        sed -i "/exec_docker_action/d" /etc/sudoers.d/sudo_base_conf
        rm -f /opt/huawei/root_tools/base/exec_docker_action.sh
    fi
    log_info "end upgrade backup service."
}

function start_rollback()
{
    log_info "begin rollback backup service."
    if [[ -f /opt/huawei/dj/tools/base/DJserviceControl.sh ]]; then
        DJserviceControl stop
        CHECK_RESULT $? "Stop DJserviceControl failed before rollback."
    fi
}

function stop_rollback()
{
    rm -rf /opt/huawei/dj /opt/huawei/root_tools
    old_version_data_file="${LINE_ROOT}/old_version_data.tar.gz"
    upgrade_files="${LINE_ROOT}/upgrade_files.tar.gz"
    check_tar_file_before_unzip "${old_version_data_file}"
    CHECK_RESULT $? "Check old_version_data.tar.gz failed."
    check_tar_file_before_unzip "${upgrade_files}"
    CHECK_RESULT $? "Check upgrade_files.tar.gz failed."
    tar -P -xzf "${old_version_data_file}" >/dev/null 2>&1
    tar -P -xzf "${upgrade_files}" >/dev/null 2>&1
    DJserviceControl start
    CHECK_RESULT $? "Start DJserviceControl failed after rollback."
    log_info "end rollback backup service."
}

if [[ "$1" == "begin_upgrade" ]];then
    start_upgrade
elif [[ "$1" == "end_upgrade" ]];then
    stop_upgrade
elif [[ "$1" == "begin_rollback" ]];then
    start_rollback
elif [[ "$1" == "end_rollback" ]];then
    stop_rollback
fi