#!/bin/bash
# 提供shell在root下校验ip能力
function check_ip()
{
    result=$(echo "$1" | awk -F. '$1<=255&&$2<=255&&$3<=255&&$4<=255{print "yes"}')
    if echo "$1" | xargs | grep -E "^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$">/dev/null; then
        if [[ ${result:-no} == "yes" ]]; then
            return 0
        fi
    fi
    return 1
}
# 提供shell在root下校验时分能力
function check_hour_minute()
{
    result=$(echo "$1" | awk -F: '$1>=0&&$1<=23&&$2>=0&&$2<=59{print "yes"}')
    if echo "$1" | xargs | grep -E "^[0-9]{1,2}\:[0-9]{1,2}$">/dev/null; then
        if [[ ${result:-no} == "yes" ]]; then
            return 0
        fi
    fi
    return 1
}
# 提供shell在root下校验ip和域名能力
function check_domain_or_ip()
{
    domain_regex="^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$"
    if  [[ "$1" =~ ${domain_regex} ]];then
        return 0
    fi
    check_ip "$1"
}
