#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo "$(readlink -f "$0")" "$@";exit $?
fi
source /opt/huawei/root_tools/base/root_utils.sh

# 外部输入参数使用前需要校验
[[ $# -lt 2 ]] && exit 1
[[ "$2" != "false" ]] && [[ "$2" != "true" ]] && exit 1
[[ "$2" = "false" ]] && [[ $# -ne 2 ]] && exit 1
REPORT_TYPE="$1"
ENABLE="$2"

if [[ "$2" = "true" ]];then
    [[ $# -ne 4 ]] && exit 1
    INPUT_TIME="$3"
    check_hour_minute "${INPUT_TIME}" >/dev/null 2>&1 || exit 2
    [[ "$4" != "zh" ]] && [[ "$4" != "en" ]] && exit 1
    LANGUAGE="$4"
fi


function backup_detail() {
    tool="/opt/huawei/dj/tools/cli-client/auto_export_backup_detail_report.sh"
    sed -i "\%${tool}%d" /etc/cron.d/crontab_cliclient.conf
    if [[ "$ENABLE" == "false" ]];then
     exit 0
    fi
    sed -i "s/kangaroo-tools backup_detail_report.*/kangaroo-tools backup_detail_report --report day_before -a true -l ${LANGUAGE}/g" "${tool}"
    IFS=":" read -r -a TIME <<< "${INPUT_TIME}"
    echo "${TIME[1]} ${TIME[0]} * * * openstack /bin/bash ${tool}" >> /etc/cron.d/crontab_cliclient.conf
    echo "[INFO] The automatic export of backup_detail reports is configured successfully."
}


function main() {
    case ${REPORT_TYPE} in
        backup_detail)
            echo "[INFO] config backup_detail cmd."
            backup_detail
            ;;
        *)
            echo "[ERROR] Unsupported report type."
            exit 1
            ;;
    esac
    service cron restart
}

main
