#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/tools/inspect/inspectLib.sh
# **************************************************************************** #
# Function Name: exec_status_inspect
# Description: exec inspect on all node
# Parameter:
# Return:
# **************************************************************************** #
function exec_status_inspect()
{
    IFS="," read -r -a NODE_LIST <<< "$(get_info manage_ip_list)"
    for node in "${NODE_LIST[@]}";do
        cmd_manager --node_ip "${node}" --cmd "${CURRENT_PATH}/inspect.sh" --parameters "${node}" --parameters "$1" >/dev/null 2>&1;ret_code=$?
        if [[ "${ret_code}" -eq 0 ]];then
            [[ -z "${msg_tip}" ]] && msg_tip="$1:[${node}:Normal]" || msg_tip="${msg_tip}[${node}:Normal]"
        elif [[ ${ret_code} -eq 10 ]] || [[ ${ret_code} -eq 404 ]];then
            [[ -z "${msg_tip}" ]] && msg_tip="$1:[${node}:NA]" || msg_tip="${msg_tip}[${node}:NA]"
        else
            [[ -z "${msg_tip}" ]] && msg_tip="$1:[${node}:Exception]" || msg_tip="${msg_tip}[${node}:Exception]"
            result="failed"
        fi
    done
    if [[ -z "${result}" ]];then
        WriteNormalItemResultToXml "${1}0" 0 "${msg_tip}"
    else
        WriteErrorItemResultToXml "${1}0" 0 "${msg_tip}" 1;RET=1
    fi
}
################################ main #####################################
if [[ $# -ne 2 ]];then
    echo "Usage: inspectMain.sh -c <param>"
    exit 1
fi

case $1 in
    -c)
        ;;
    *)
        echo "Usage: inspectMain.sh -c <param>"
        exit 1
        ;;
esac

case $2 in
    clusterStatus)
        ;;
    memory)
        ;;
    diskfree)
        ;;
    cpuStatus)
        ;;
    cps-monitor)
        ;;
    zookeeper)
        ;;
    gaussdb)
        ;;
    omm-ha)
        ;;
    haproxy)
        ;;
    rabbitmq)
        ;;
    cms)
        ;;
    scagent)
        ;;
    resource_manager)
        ;;
    alarm)
        ;;
    karbor)
        ;;
    defaultPwd)
        ;;
    *)
        echo "Ivalid param"
        exit 1
        ;;
esac


WriteResultHeaderToXml "$2"
case $2 in
    clusterStatus)
        bash "${CURRENT_PATH}/inspect.sh" "local" "$2" >/dev/null 2>&1;ret_code=$?
        if [[ ${ret_code} -eq 0 ]];then
            WriteNormalItemResultToXml "clusterStatus0" 0 "clusterStatus:Normal"
        else
            WriteErrorItemResultToXml "clusterStatus0" 0 "clusterStatus:Exception" 1;RET=1
        fi
        ;;
    defaultPwd)
        msg_tip=$(bash "${CURRENT_PATH}/inspect.sh" "local" "$2");ret_code=$?
        if [[ ${ret_code} -eq 0 ]];then
            WriteNormalItemResultToXml "defaultPwd0" 0 "defaultPwd:Normal"
        else
            WriteErrorItemResultToXml "defaultPwd" 0 "defaultPwd:$(head -n1 <<< "${msg_tip}")" 1;RET=1
        fi
        ;;
    *)
        exec_status_inspect "$2";;
esac
WriteResultEndToXml
cat "${CHECK_RESULT_FILE}" && rm -f "${CHECK_RESULT_FILE}"
exit ${RET}