#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init omm-ha rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/ha
    log_info "Finish omm-ha rsyslog configuration."
}

function install_script()
{
    log_info "Init omm-ha script configuration."
    omm_ha_dir=$(find "${CURRENT_PATH}" -maxdepth 1 -type d -name "HA*")
    /usr/bin/mv ${omm_ha_dir}/software /opt/huawei/dj/bin/ha
    CHECK_RESULT $? "install omm-ha platform failed."
    /usr/bin/cp -rf "${CURRENT_PATH}/arbitrationtool" /opt/huawei/dj/bin
    CHECK_RESULT $? "Install omm-ha arb arbitrationtool Failed."
    mkdir -p /opt/huawei/dj/bin/ha/local/conf
    log_info "Finish omm-ha script configuration."
}

function install_tools()
{
    log_info "Init omm-ha tools configuration."
    mkdir -p /opt/huawei/dj/tools/omm-ha
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/omm-ha
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/omm-ha/omm-haControl.sh
    create_link /opt/huawei/dj/bin/arbitrationtool/bin/getArbRst.sh
    log_info "Finish omm-ha tools configuration."
}

function install_conf()
{
    log_info "Init omm-ha conf configuration."
    log_info "Finish omm-ha conf configuration."
}

function install_version()
{
    log_info "Init omm-ha version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/omm-ha.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy omm-ha version Failed."
    log_info "Finish omm-ha version configuration."
}

function install_permission()
{
    log_info "Init omm-ha permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/bin/ha/module "*.xml"
    set_modify_permission /opt/huawei/dj/bin/ha/local
    set_modify_permission /opt/huawei/dj/bin/arbitrationtool/conf
    set_modify_permission /var/log/huawei/dj
    log_info "Finish omm-ha permission configuration."
}

function install_root()
{
    log_info "Init omm-ha root configuration."
    install_sudo_conf "${CURRENT_PATH}/conf/sudo_omm_ha_conf"
    install_root_tools omm-ha "${CURRENT_PATH}/root_sudo/update_ip_conf.sh"
    log_info "Finish omm-ha root configuration."
}

function install_crontab()
{
    log_info "Init omm-ha crontab configuration."
    log_info "Finish omm-ha crontab configuration."
}


log_info "Start omm-ha installation."
install_root
install_rsyslog
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish omm-ha installation."