#!/usr/bin/proxython
import configparser
import sys

try:
    import netifaces
except ImportError:
    # These modules do not exist when executing pre install
    pass

CONF_FILE_PATH = "/opt/huawei-data-protection/agentproxy/conf/agentproxy.conf"
FEATURE = []
parser = configparser.RawConfigParser()
parser.read(CONF_FILE_PATH)


def get_local_ip():
    try:
        ip_version = get_config("ip_version")
        net = netifaces.AF_INET6 if ip_version == "ipv6" else netifaces.AF_INET
        interface = netifaces.gateways()['default'][net][1]
        return netifaces.ifaddresses(interface)[net][0]['addr']
    except Exception:
        return None


def get_default_gateway():
    try:
        ip_version = get_config("ip_version")
        net = netifaces.AF_INET6 if ip_version == "ipv6" else netifaces.AF_INET
        return netifaces.gateways()['default'][net][0]
    except Exception:
        return None


def get_config(key, section=None):
    section = section or "SYSTEM"
    opt = parser.options(section)
    if key not in opt:
        return None
    return parser.get(section, key)


def get_ha_peer_node():
    ha_nodes = get_config("omm-ha_nodes").split(',')
    local_ip = get_local_ip()
    for node in ha_nodes:
        if node != local_ip and local_ip in ha_nodes:
            return node
    return None


def get_net_mask_num():
    netmask = get_config("net_mask")
    res = ""
    for mask in netmask.split('.'):
        res += str(bin(int(mask)))[2:]
    return len("".join(str(res).split('0')[0:1]))


function_map = {
    "manage_ip": get_local_ip,
    "ha_peer_node": get_ha_peer_node,
    "default_gateway": get_default_gateway,
    "mask_num": get_net_mask_num
}


def get_parameters_value(item1, item2=None):
    if item1 in function_map.keys():
        return function_map[item1]()
    return get_config(item1, item2)


def main(argv):
    if len(argv) < 1 or len(argv) > 2:
        print("Parameter inputed error!")
        return 1
    param1 = argv[0].lstrip("-").lower()
    param2 = None
    if len(argv) == 2:
        param2 = argv[1].upper()
    print(get_parameters_value(param1, param2))
    return 0


if __name__ == "__main__":
    code = main(sys.argv[1:])
    exit(code)
