#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname ${CURRENT_PATH})
source ${CURRENT_PATH}/utils.sh
LOG_TAG="proxy_install"

function _uninstall_others()
{
    rm -rf /home/{agentproxy,dpamanager}
    userdel -rf dpamanager >/dev/null 2>&1
    userdel -rf agentproxy >/dev/null 2>&1
    groupdel agentproxy >/dev/null 2>&1
    rm -rf /usr/bin/get_info.py
    rm -f /usr/bin/showsys
    rm -rf /etc/sudoers.d/{dpamanager,agentproxy}
    rm -rf /var/log/huawei-data-protection/agentproxy
    rm -rf /usr/local/bin/{ha,cps-monitor,zookeeper,jre}
    sed -i "s/PermitRootLogin no/PermitRootLogin yes/g"  /etc/ssh/sshd_config >/dev/null 2>&1
    service sshd restart >/dev/null 2>&1
    log_info "uninstall service successfully."
}

function _tip()
{
    while [ 1 -eq 1 ];do
        echo "Are you sure to uninstall agentproxy (y/n):"
        read char
        if [ "$char" = "y" -o "$char" = "Y" ];then
            break
        elif [ "$char" = "n" -o "$char" = "N" ];then
            exit 1
        else
            continue
        fi
    done
}

function relieve_prevent_file_tamper()
{
    local path=$(ls $1)
    for file in $path
    do
        if [ -d $1"/"$file ]
        then
            relieve_prevent_file_tamper $1"/"$file
        else
            if [ -x $1"/"$file ]
            then
                chattr -i $1"/"$file
            fi
        fi
    done
}

_tip
CHECK_RESULT $? "delete_before_local failed"
proxython ${CURRENT_PATH}/install_services.py "${LINE_ROOT}/services" --uninstall
CHECK_RESULT $? "uninstall agentproxy service failed"
_uninstall_others >/dev/null 2>&1
CHECK_RESULT $? "uninstall_others failed!"
rm -rf /opt/huawei-data-protection
if [[ $? -ne 0 ]];then
    echo "[ERROR] Uninstall service failed because uninstall service path failed..."
    exit 1
fi
