#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
source "${LINE_ROOT}/bin/utils.sh"
mapfile -t -d ',' NODE_LIST < <(get_info.py agentproxy_nodes | xargs echo -n)
MANAGE_IP=$(get_info.py manage_ip)
export LOG_TAG="proxy_install"

function check_status()
{
    check_count=0
    while [ ${check_count} -lt 10 ]; do
        start_service cps-monitor
        start_service zookeeper
        if [[ "${NODE_LIST[0]}" == "${MANAGE_IP}" ]];then
            start_service v_zookeeper
        fi
        start_service agentproxy
        sleep 30s
        check_services_status
        if [[ $? -eq 0 ]]; then
            return 0
        fi
        let ++check_count
    done
    return 1
}

check_status
CHECK_RESULT $? "upgrade service failed."
log_info "upgrade service success."
