#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname ${CURRENT_PATH})
source ${LINE_ROOT}/bin/utils.sh

# ================================= install ====================================
function install()
{
    source /etc/bashrc
    if [ ! -f "$1" ]; then
        echo "Error, please check sys.ini."
        exit 1
    else
        sh ${LINE_ROOT}/install.sh -f $1
        exit $?
    fi
}

# ================================= check ======================================
function check()
{
    if [ ! -f "/opt/huawei-data-protection/agentproxy/version" ];then
        echo "Check service end, install service failed."
        exit 1
    fi

    echo "Check service end, service has been installed successfully."
}

# ================================= rollback ===================================
function rollback()
{
    echo -e "y\n" | sh ${LINE_ROOT}/bin/uninstall.sh
    exit $?
}

# ================================= main =======================================
function main()
{
    if [ $# -lt 1 ]; then
        echo "Parameter error. Usage: bash install_agentproxy.sh [install|check|rollback]"
        exit 1
    fi
    case "$1" in
        install)
            install "$2"
        ;;
        check)
            check
        ;;
        rollback)
            rollback
        ;;
        *)
            echo "Parameter error. Usage: bash install_agentproxy.sh [install|check|rollback]"
            exit 1
        ;;
    esac
}

main "$@"
