#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
ROOT_PATH=$(dirname "${LINE_ROOT}")
OPT_PATH="/opt"
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="proxy_install"

function begin_rollback()
{
    log_info "begin rollback service."
    if [[ ! -d "${ROOT_PATH}/agentproxy" || ! -d "${OPT_PATH}/old_version_data" ]];then
        log_info "this node has not been upgraded and does not need to be rolled back."
        exit 0
    fi
    service_control STOP
    rm -f /usr/local/bin/zookeeper/data/version-2/*
    rm -f /usr/local/bin/zookeeper/logs/version-2/*
    rm -f /usr/local/bin/v_zookeeper/data/version-2/*
    rm -f /usr/local/bin/v_zookeeper/logs/version-2/*
    chattr -iR /opt/huawei-data-protection/agentproxy/pkg
    rm -f  /opt/huawei-data-protection/agentproxy/pkg/agent/*
    rm -f /opt/huawei-data-protection/agentproxy/pkg/agent_assistant/*
    tar_file="${OPT_PATH}/old_version_data.tar.gz"
    check_tar_file_before_unzip ${tar_file}
    ECHO_RETURN $? "Check ${tar_file} failed."
    tar -P -xzf ${tar_file} >/dev/null 2>&1
    chattr +i -R /opt/huawei-data-protection/agentproxy/pkg/*
    sleep 30s
    service_control RUN
    check_count=0
    while [ ${check_count} -lt 10 ]; do
        sleep 30s
        check_services_status
        if [[ $? -eq 0 ]]; then
            log_info "rollback service success."
            return 0
        fi
        let ++check_count
    done
    log_error "rollback service failed."
    exit 1
}

begin_rollback
rm -rf ${ROOT_PATH}/agentproxy
rm -rf ${OPT_PATH}/old_version_data
