#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
LOG_TAG="proxy_install"
LINE_ROOT=$(dirname ${cur_dir})
source ${LINE_ROOT}/bin/utils.sh

log_info "Install third whls packages begin..."
proxython -m pip install --no-deps --force-reinstall  ${LINE_ROOT}/repo/third_party/*.whl
CHECK_RESULT $? "Install third_party whl failed."
log_info "Install third part whl OK."

# JRE环境安装
jre_dir=$(mktemp -d ${LINE_ROOT}/nameXXXXX)
tar_file=${LINE_ROOT}/repo/platform/java/jre-*.tar.gz
check_tar_file_before_unzip ${tar_file}
ECHO_RETURN $? "Check ${tar_file} failed."
tar -xf ${tar_file} -C ${jre_dir}
mkdir -p /usr/local/bin/jre
/usr/bin/mv -f "${jre_dir}"/jre* /usr/local/bin/jre && rm -rf "${jre_dir}"
CHECK_RESULT $? "Install Jre failed."
jre_path=`ls /usr/local/bin/jre | grep "^jre*"`
export PATH=/usr/local/bin/jre/"${jre_path}"/bin:${PATH}
rm -f /usr/bin/java && ln -sf /usr/local/bin/jre/"${jre_path}"/bin/java /usr/bin/java
set_exec_permission /usr/local/bin/jre
log_info "Install Jre success."
