#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
SERVICE_PATH="/opt/huawei-data-protection/agentproxy"
ROOT_TOOLS_PATH="/opt/huawei-data-protection/root_tools"
SYS_CONF_PATH="/opt/huawei-data-protection/agentproxy/conf"
TOOL_PATH="/opt/huawei-data-protection/agentproxy/tools/agentproxy"


function install_agentproxy()
{
    rm -f ${SERVICE_PATH}/tmp/*
    tar_file=${LINE_ROOT}/repo/self_developed/agentproxy*.tar.gz
    check_tar_file_before_unzip ${tar_file}
    ECHO_RETURN $? "Check ${tar_file} failed."
    tar -zxvf ${tar_file} -C ${SERVICE_PATH}/tmp >/dev/null 2>&1
    if [[ $? -ne 0 ]]; then
        echo "install agentproxy failed,quit."
        exit 1
    fi
    mv ${SERVICE_PATH}/tmp/agentproxy/agent_proxy "${ROOT_TOOLS_PATH}"
    mv ${SERVICE_PATH}/tmp/agentproxy/* ${SERVICE_PATH}/bin
    rm -rf ${SERVICE_PATH}/tmp/agentproxy
    /usr/bin/cp -f ${LINE_ROOT}/conf/rest_provider.json ${SYS_CONF_PATH}
    mkdir -p /usr/local/bin/cmscbb/lib
    /usr/bin/cp -f "${LINE_ROOT}"/repo/third_party/cmscbb.jar /usr/local/bin/cmscbb/lib
    /usr/bin/cp -f ${CURRENT_PATH}/tools/*  ${TOOL_PATH}
    mkdir "${ROOT_TOOLS_PATH}/ops"
    mv "${SERVICE_PATH}/bin/changeOsCipher.sh" "${ROOT_TOOLS_PATH}/ops/"
    mv "${SERVICE_PATH}/bin/gen_ssh_key.exp" "${ROOT_TOOLS_PATH}/ops/"
    chown -hR root:root "${ROOT_TOOLS_PATH}/ops"
    set_root_exec_permission "${ROOT_TOOLS_PATH}/agent_proxy"

    chmod 500 ${SERVICE_PATH}/bin/set_zk_client_password.py
    rm -f /usr/bin/set_zk_client_password
    ln -sf ${SERVICE_PATH}/bin/set_zk_client_password.py /usr/bin/set_zk_client_password
    chown -h agentproxy:agentproxy /usr/bin/set_zk_client_password
    create_link ${TOOL_PATH}/agentproxyControl.sh
}

function check_zookeeper_status()
{
    fail_count=0
    while [ ${fail_count} -lt 10 ]; do
        zookeeperControl -CS CompontState
        if [ $? -eq 2 -o $? -eq 3 ]; then
            log_info "Check zookeeper status success..."
            return 0
        fi
        let ++fail_count
        log_warn "Check zookeeper status failed, fail_count=${fail_count}..."
        sleep 30
    done
    echo_error "Check zookeeper status failed..."
    return 1
}

function chmod_files()
{
    set_rw_permission /var/log/huawei-data-protection >/dev/null 2>&1
    set_common_permission /opt/huawei-data-protection >/dev/null 2>&1
    set_least_rw_permission ${SERVICE_PATH}/certs >/dev/null 2>&1
    set_least_rw_permission ${SERVICE_PATH}/conf >/dev/null 2>&1
    set_least_rw_permission ${SERVICE_PATH}/data_bak >/dev/null 2>&1
    set_least_rw_permission ${SERVICE_PATH}/logs >/dev/null 2>&1
    set_least_rw_permission ${SERVICE_PATH}/pkg >/dev/null 2>&1
    set_least_exec_permission ${SERVICE_PATH}/bin >/dev/null 2>&1
    set_least_exec_permission ${SERVICE_PATH}/inspect >/dev/null 2>&1
    set_least_exec_permission ${SERVICE_PATH}/tools >/dev/null 2>&1
    set_least_common_permission ${SERVICE_PATH}/tmp >/dev/null 2>&1
    set_least_common_permission ${SERVICE_PATH}/inst >/dev/null 2>&1
    set_exec_permission ${ROOT_TOOLS_PATH}/ops >/dev/null 2>&1
    chmod 400 ${SERVICE_PATH}/certs/agentproxy/cms_cert/*.eps
}

function config_iptables()
{
    IP_RANGE=`cat /opt/huawei-data-protection/agentproxy/conf/agentproxy.conf | grep '^agentproxy_nodes' | awk -F '=' '{print $2}' | sed 's/,/\-/g' | sed 's/^[ \t]*//g'`
    rm -rf /etc/sysconfig/iptables
    iptables -F INPUT

    ##############################################################################
    # 配置INPUT白名单
    ##############################################################################
    # 配置iptables INPUT关联策略
    iptables -C INPUT -m state --state ESTABLISHED -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -m state --state ESTABLISHED -j ACCEPT
    # 允许其他机器ping通本机地址
    iptables -C INPUT -p icmp --icmp-type echo-request -j ACCEPT  >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -p icmp --icmp-type echo-request -j ACCEPT
    # 允许本地回环输入
    iptables -C INPUT -i lo -j ACCEPT  >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -i lo -j ACCEPT
    # 允许对本机123端口udp访问
    iptables -C INPUT -p udp --dport 123 -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -p udp --dport 123 -j ACCEPT
    # 允许对本机22端口tcp访问
    iptables -C INPUT -p tcp --dport 22 -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -p tcp --dport 22 -j ACCEPT
    # 允许对本机KarborProxy端口访问
    iptables -C INPUT -p tcp --dport 8088 -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -p tcp --dport 8088 -j ACCEPT
    iptables -C INPUT -p tcp --dport 8089 -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -p tcp --dport 8089 -j ACCEPT
    # 允许对本机MOICAgent端口访问
    iptables -C INPUT -p tcp --dport 26401 -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -p tcp --dport 26401 -j ACCEPT
    # 允许集群IP对本机端口访问
    iptables -C INPUT -m iprange --src-range ${IP_RANGE} -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -m iprange --src-range ${IP_RANGE} -j ACCEPT

    ##############################################################################
    # 配置 OUTPUT白名单
    ##############################################################################
    # 允许输出到本地回环
    iptables -C OUTPUT -o lo -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A OUTPUT -o lo -j ACCEPT
    # 配置iptables OUTPUT关联策略
    iptables -C OUTPUT -m state --state NEW,ESTABLISHED -j ACCEPT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A OUTPUT -m state --state NEW,ESTABLISHED -j ACCEPT

    ##############################################################################
    # 配置INPUT拒绝策略
    ##############################################################################
    # 禁止127私网设备
    iptables -C INPUT -s 127.0.0.0/8 -j REJECT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -s 127.0.0.0/8 -j REJECT
    # 禁止对本机非白名单端口访问
    iptables -C INPUT -j REJECT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A INPUT -j REJECT

    ##############################################################################
    # 配置OUTPUT拒绝策略
    ##############################################################################
    # 禁止本机icmp的类型timestamp-request探测
    iptables -C OUTPUT -p icmp -m icmp --icmp-type timestamp-request -j REJECT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A OUTPUT -p icmp -m icmp --icmp-type timestamp-request -j REJECT
    # 禁止本机icmp的类型redirect探测
    iptables -C OUTPUT -p icmp -m icmp --icmp-type redirect -j REJECT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A OUTPUT -p icmp -m icmp --icmp-type redirect -j REJECT
    # 禁止本机icmp的类型timestamp-reply探测
    iptables -C OUTPUT -p icmp -m icmp --icmp-type timestamp-reply -j REJECT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A OUTPUT -p icmp -m icmp --icmp-type timestamp-reply -j REJECT
    # 禁止本机icmp的类型16探测
    iptables -C OUTPUT -p icmp -m icmp --icmp-type 16 -j REJECT >/dev/null 2>&1
    [[ $? -ne 0 ]] && iptables -A OUTPUT -p icmp -m icmp --icmp-type 16 -j REJECT

    service iptables save
    service iptables restart
    chkconfig iptables on
    log_info "Config iptables finished."
}

function config_logrotate_for_sudolog()
{
    if [ ! -f "/etc/logrotate.d/sudolog" ]
    then
        touch /etc/logrotate.d/sudolog
        echo "/var/log/sudo.log {
    compress
    maxage 180
    rotate 5
    size=+40M
    notifempty
    missingok
    copytruncate
}
" > /etc/logrotate.d/sudolog
    fi
}

config_logrotate_for_sudolog
log_info "Start config iptables."
config_iptables
if [[ $? -ne 0 ]]; then
    echo_error "config iptables falied......"
    exit 1
fi

log_info "Start agentproxy installation."
install_agentproxy
if [[ $? -ne 0 ]]; then
    echo_error "install agentproxy falied......"
    exit 1
fi
log_info "install agentproxy success..."
check_zookeeper_status
if [[ $? -ne 0 ]]; then
    echo_error "check zookeeper status falied......"
    exit 1
fi
log_info "check zookeeper status success..."
chmod_files
if [[ $? -ne 0 ]]; then
    echo_error "chmod files falied......"
    exit 1
fi
log_info "chmod files success..."
