#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
ROOT_PATH=$(dirname "${LINE_ROOT}")
CERTS_PATH="/opt/huawei-data-protection/agentproxy/certs"
CONF_PATH="/opt/huawei-data-protection/agentproxy/conf"
OLD_FILE_PATH="/opt/old_version_data/opt/huawei-data-protection/agentproxy"
source "${LINE_ROOT}"/bin/utils.sh
export LOG_TAG="proxy_install"

sh "${LINE_ROOT}"/repo/third_party_deploy.sh
CHECK_RESULT $? "Third party deploy failed."

mkdir -p ${CONF_PATH}/kmc
/usr/bin/cp -f "${LINE_ROOT}"/conf/kmc/* ${CONF_PATH}/kmc
systemctl restart haveged
if [[ $# -eq 0 ]];then
    bash "${LINE_ROOT}"/bin/osConfig/ssh_config.sh
    CHECK_RESULT $? "Config ssh and rsyslog failed."
fi

if [[ $# -eq 0 ]];then
    bash "${LINE_ROOT}"/bin/create_cert.sh
    CHECK_RESULT $? "Create certs failed."
else
    mkdir -p "${LINE_ROOT}"/conf/agentproxy/{https_cert,rpc_cert,tcp_cert}
    mkdir -p "${LINE_ROOT}"/conf/{haproxy,omm-ha}
    old_cert_path="${OLD_FILE_PATH}"/certs
    /usr/bin/cp -f ${old_cert_path}/agentproxy/https_cert/* "${LINE_ROOT}"/conf/agentproxy/https_cert
    /usr/bin/cp -f ${old_cert_path}/agentproxy/rpc_cert/* "${LINE_ROOT}"/conf/agentproxy/rpc_cert
    /usr/bin/cp -f ${old_cert_path}/agentproxy/tcp_cert/* "${LINE_ROOT}"/conf/agentproxy/tcp_cert
    /usr/bin/cp -f ${old_cert_path}/haproxy/* "${LINE_ROOT}"/conf/haproxy
    /usr/bin/cp -f ${old_cert_path}/omm-ha/* "${LINE_ROOT}"/conf/omm-ha
    old_privkey_path="${OLD_FILE_PATH}"/conf/haproxy
    /usr/bin/cp -f "${old_privkey_path}"/privkey.conf "${LINE_ROOT}"/conf/privkey.conf
    /usr/bin/cp -rf "${OLD_FILE_PATH}"/conf/kmc /opt/huawei-data-protection/agentproxy/conf
fi

encrypt_password=$(< "${LINE_ROOT}"/conf/privkey.conf awk '{print $2}')
echo "${encrypt_password}" | grep -E "^[A-F0-9#]+$" > /dev/null
CHECK_RESULT $? "Invalid encrypt_password."
sed -i "s/^https_cert_pwd.*/https_cert_pwd=${encrypt_password}/g" "${CONF_PATH}"/agentproxy.conf
sed -i "s/^tcp_cert_pwd.*/tcp_cert_pwd=${encrypt_password}/g" "${CONF_PATH}"/agentproxy.conf
sed -i "s/^rpc_cert_pwd.*/rpc_cert_pwd=${encrypt_password}/g" "${CONF_PATH}"/agentproxy.conf

mkdir -p ${CERTS_PATH}
mkdir -p ${CERTS_PATH}/{haproxy,agentproxy/iam_cert,agentproxy/oc_cert,agentproxy/kmc_cert,agentproxy/karbor_cert,omm-ha}
/usr/bin/cp -rf "${LINE_ROOT}"/conf/agentproxy/* ${CERTS_PATH}/agentproxy
/usr/bin/cp -f "${LINE_ROOT}"/conf/omm-ha/* ${CERTS_PATH}/omm-ha
/usr/bin/cp -f "${LINE_ROOT}"/conf/haproxy/* ${CERTS_PATH}/haproxy
/usr/bin/cp -f "${LINE_ROOT}"/conf/agentproxy/https_cert/http_ca-cert.pem /usr/lib/proxython/site-packages/certifi/cacert.pem
/usr/bin/cp -f "${LINE_ROOT}"/conf/agentproxy/https_cert/http_ca-cert.pem /usr/lib/proxython/site-packages/pip/_vendor/certifi/cacert.pem
CHECK_RESULT $? "Config agentproxy certs failed."

mkdir -p ${CONF_PATH}/{haproxy,zookeeper,omm-ha}
/usr/bin/cp -f "${LINE_ROOT}"/conf/cert_info.json ${CONF_PATH}
/usr/bin/cp -f "${LINE_ROOT}"/conf/privkey.conf ${CONF_PATH}/haproxy
/usr/bin/cp -f "${LINE_ROOT}"/conf/privkey.conf ${CONF_PATH}/omm-ha
CHECK_RESULT $? "Config conf failed."

mkdir $CERTS_PATH/agentproxy/{cms_cert,https_cert,iam_cert,oc_cert,rpc_cert,tcp_cert,kmc_cert,karbor_cert}/bak
mkdir $CERTS_PATH/{haproxy,omm-ha}/bak
/usr/bin/cp -f $CERTS_PATH/agentproxy/cms_cert/* $CERTS_PATH/agentproxy/cms_cert/bak >/dev/null 2>&1
/usr/bin/cp -f $CERTS_PATH/agentproxy/https_cert/* $CERTS_PATH/agentproxy/https_cert/bak >/dev/null 2>&1
/usr/bin/cp -f $CERTS_PATH/agentproxy/iam_cert/* $CERTS_PATH/agentproxy/iam_cert/bak >/dev/null 2>&1
/usr/bin/cp -f $CERTS_PATH/agentproxy/oc_cert/* $CERTS_PATH/agentproxy/oc_cert/bak >/dev/null 2>&1
/usr/bin/cp -f $CERTS_PATH/agentproxy/rpc_cert/* $CERTS_PATH/agentproxy/rpc_cert/bak >/dev/null 2>&1
/usr/bin/cp -f $CERTS_PATH/agentproxy/tcp_cert/* $CERTS_PATH/agentproxy/tcp_cert/bak >/dev/null 2>&1
/usr/bin/cp -f $CERTS_PATH/haproxy/* $CERTS_PATH/haproxy/bak >/dev/null 2>&1
/usr/bin/cp -f $CERTS_PATH/omm-ha/* $CERTS_PATH/omm-ha/bak >/dev/null 2>&1

function install_tools()
{
    mkdir -p /opt/huawei-data-protection/agentproxy/tools/base
    /usr/bin/cp -f "${LINE_ROOT}"/services/base/tools/servicesControl.sh /opt/huawei-data-protection/agentproxy/tools/base
    log_info "Init base tools configuration."
    {
        echo '#!/bin/bash'
        echo '# chkconfig: 2345 10 90'
        echo 'systemctl restart haveged'
        echo 'sudo -u agentproxy bash /opt/huawei-data-protection/agentproxy/tools/base/servicesControl.sh $@ &'
    } >/etc/init.d/DPAControl
    chmod u+x /etc/init.d/DPAControl && /sbin/chkconfig --add DPAControl
    CHECK_RESULT $? "Add DPAControl to auto start failed."
    /sbin/chkconfig --list DPAControl
    CHECK_RESULT $? "Check DPAControl from auto start failed."
    log_info "Finish base tools configuration."
}

install_tools
chown -h agentproxy:agentproxy /opt/huawei-data-protection && chmod 750 /opt/huawei-data-protection
set_common_permission /opt/huawei-data-protection/
log_info "Install base finish."
