#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi
source /opt/huawei-data-protection/agentproxy/inst/bin/utils.sh
export LOG_TAG="servicesControl"
SERVICE_LIST=("cps-monitor" "omm-ha" "haproxy" "zookeeper" "agentproxy")

function start_service()
{
    log_info "Begin start services..."
    for service in "${SERVICE_LIST[@]}";do
        check_count=0
        while [ ${check_count} -lt 60 ]; do
            "${service}"Control -S RUN
            if [[ "${service}" == "zookeeper" ]];then
                omha_status=`omm-haControl -CS CompontState | awk -F ' ' '{print $NF}' | sed -n '2p'`
                if [[ ${om_status} == "active" ]];then
                    v_"${service}"Control -S RUN
                fi
            fi
            check_service_status "${service}"
            if [[ $? -eq 0 ]];then
                 log_info "Start ${service} service success."
                 break
            fi
            let ++check_count
            sleep 10
        done
    done
    log_info "All services started successfully."
}

uptime=$(awk '{print $1}' /proc/uptime)
uptime_second=${uptime%.*}
if [ -n "${uptime_second}" ] && [ "${uptime_second}" -lt "40" ];then
    sleep 30
    echo_info "========System new reboot here======="
fi
start_service
exit 0