#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
TOOL_PATH="/opt/huawei-data-protection/agentproxy/tools/cps-monitor"
SUDO_PATH="/opt/huawei-data-protection/root_tools/cps-monitor"
CPS_PATH="/usr/local/bin/cps-monitor"

function install_cps_monitor()
{
    proxython -m pip install --no-deps --force-reinstall ${LINE_ROOT}/repo/self_developed/cps_monitor-*.whl
    if [ $? -ne 0 ];then
        log_error "install cps-monitor fail..."
        exit 1
    fi
    log_info "install cps-monitor success..."

    mkdir -p ${TOOL_PATH} ${SUDO_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    set_least_common_permission ${TOOL_PATH}
    create_link ${TOOL_PATH}/cps-monitorControl.sh
    /usr/bin/cp -f ${CURRENT_PATH}/root_tools/* ${SUDO_PATH}
    chmod 550 ${SUDO_PATH}/*.sh
    log_info "install cps-monitor tools success..."
}

function chmod_monitor()
{
    set_least_common_permission /usr/lib/proxython/site-packages >/dev/null 2>&1
    set_least_common_permission ${CPS_PATH} >/dev/null 2>&1
    set_least_rw_permission ${CPS_PATH}/cps_mon.share >/dev/null 2>&1
    set_least_rw_permission ${CPS_PATH}/kms_alarm.flag >/dev/null 2>&1
}

function set_sudoers_for_cps_monitor()
{
    sed -i "/\/update_date.sh/d" /etc/sudoers.d/agentproxy > /dev/null
    echo "%agentproxy ALL = (root) NOPASSWD:${SUDO_PATH}/update_date.sh" >> /etc/sudoers.d/agentproxy
}

function restart_dependence_service()
{
    zookeeperControl -A RESTART
    if [[ $? -ne 0 ]];then
        echo_error "Restart zookeeper failed..."
        exit 1
    fi
    echo_info "Restart zookeeper success..."
    local zk_nodes=($(get_info.py zookeeper_nodes | sed 's/,/ /g'))
    local manage_ip=$(get_info.py manage_ip)
    if [[ "${zk_nodes[0]}" == "${manage_ip}" ]];then
        v_zookeeperControl -A RESTART
        if [[ $? -ne 0 ]];then
            echo_error "Restart v_zookeeper failed..."
            exit 1
        fi
        echo_info "Restart v_zookeeper success..."
        return 0
    else
        echo_info "No need restart v_zookeeper..."
        return 0
    fi
    echo_info "Restart dependence services finished..."
}

install_cps_monitor
chmod_monitor
set_sudoers_for_cps_monitor
restart_dependence_service
