#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
CPS_PATH="/usr/local/bin/cps-monitor"
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"

if [ -f "/usr/bin/cps-monitorControl" ];then
    cps-monitorControl -S STOP
    if [ $? -ne 0 ];then
        log_error "stop cps-monitor failed."
        exit 1
    fi
fi

function umount_cps_monitor_dir()
{
    dst_path=$1
    mount -l | grep "$dst_path "
    res=$?
    if [ "${res}" -eq 0 ];then
        umount -t ramfs $dst_path >> /dev/null 2>&1
    fi
}

function uninstall()
{
    ps -ef | grep cps_monitor | awk '{print $2}' | xargs -r kill -9
    rpm -qa | grep -w 'cps-monitor' >/dev/null
    if [ $? -eq 0 ]; then
        log_info "uninstall cps-monitor rpm in this node"
        rpm -e cps-monitor
    fi
    sed -i '/log_monitor.sh/d' /etc/crontab
    sed -i '/sys_monitor.sh/d' /etc/crontab
    service cron restart
    dst_path="/usr/lib/proxython/site-packages/cps_monitor/common"
    umount_cps_monitor_dir $dst_path
    dst_path="/usr/lib/proxython/site-packages/cps_monitor/cps_monitor/common"
    umount_cps_monitor_dir $dst_path
    rm -rf /usr/lib/proxython/site-packages/cps_monitor >> /dev/null 2>&1
    rm -rf ${CPS_PATH}
    if [[ $# -eq 0 ]];then
        rm -rf /var/log/huawei-data-protection/agentproxy/services/cps-monitor
    fi
    rm /usr/bin/cps-monitorControl
    log_info "uninstall cps-monitor rsyslog conf success."
    log_info "uninstall cps-monitor success."
}

uninstall $1