#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi

set +x
CURRENT_PATH=$(dirname $(readlink -f $0))
source /opt/huawei-data-protection/agentproxy/inst/bin/utils.sh

component="haproxy"
LOG_TAG="haproxyControl"
LOG_FILE="/var/log/huawei-data-protection/agentproxy/services/haproxy/haproxyControl.log"

function stopHeartBeat()
{
    proxython /usr/lib/proxython/site-packages/cps_monitor/heartBeat.py STOP ${component}
    if [[ $? -ne 0 ]]; then
        echo_error "Unregister heartbeat of ${component} failed..."
        return 1
    fi
    log_info "Unregister heartbeat of ${component} success..."
}

function startHeartBeat()
{
    proxython /usr/lib/proxython/site-packages/cps_monitor/heartBeat.py START ${component}
    if [[ $? -ne 0 ]]; then
        echo_error "Register heartbeat of ${component} failed..."
        return 1
    fi
    log_info "Register heartbeat of ${component} success..."
}

function component_run()
{
    echo "Begin start ${component}..."
    log_info "Begin start ${component}..."
    queryCmd=$(pgrep -f /usr/sbin/haproxy)
    if [[ "${queryCmd}" ]]; then
        echo "${component} is  running..."
        return 0
    fi
    fail_count=0
    while [ ${fail_count} -lt 3 ]; do
        bash ${CURRENT_PATH}/haproxy_run.sh >/dev/null 2>>${LOG_FILE} &
        sleep 5
        queryCmd=$(pgrep -f /usr/sbin/haproxy)
        if [[ "${queryCmd}" ]]; then
            startHeartBeat
            echo_info "Start ${component} success..."
            log_info "Start ${component} success..."
            return 0
        fi
        let ++fail_count
        echo "Start ${component} failed, fail_count=${fail_count}..."
        log_warn "Start ${component} failed, fail_count=${fail_count}..."
        sleep 10
    done
    echo "Start ${component} failed..."
    log_error "Start ${component} failed..."
    exit 1
}

function component_stop()
{
    echo "Begin stop ${component}..."
    log_info "Begin stop ${component}..."
    fail_count=0
    while [ ${fail_count} -lt 3 ]; do
        kill -9 $(pgrep -f /usr/sbin/haproxy) >/dev/null 2>&1
        queryCmd=$(pgrep -f /usr/sbin/haproxy)
        if [[ -z "${queryCmd}" ]]; then
            stopHeartBeat
            echo_info "Stop ${component} success..."
            log_info "Stop ${component} success..."
            return 0
        fi
        let ++fail_count
        log_warn "Stop ${component} failed, fail_count=${fail_count}..."
        sleep 5
    done
    echo_error "Stop ${component} failed..."
    log_error "Stop ${component} failed..."
    exit 1
}

function component_restart()
{
    echo "haproxy:component_restart begin"

    echo "haproxy:component_restart end"
}

function component_status()
{
    pgrep -f /usr/sbin/haproxy >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo -e "\n ${component} was dead\n"
        exit 1
    fi
    echo  -e "\n ${component} is running\n"
    exit 0
}

cd ${CURRENT_PATH}
while true; do
    case "$1" in
        -S) Action1=$2;shift 2; break;;
        -CS) Action2=$2;shift 2; break;;
        -A) Action3=$2;shift 2; break;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action3}" ]; then
    component_stop
    component_run
elif [ "RUN" = "${Action1}" ]; then
    component_run
elif [ "STOP" = "${Action1}" ]; then
    component_stop
elif [ "CompontState" = "${Action2}" ];then
    component_status
else
    show_cmd_help ${component}
fi
exit 0
