#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi

function get_password()
{
    local private_key='/opt/huawei-data-protection/agentproxy/conf/haproxy/privkey.conf'
    local key=$(cat "${private_key}" | awk '{print $2}')
    export ENCRYPT_DATA="${key}"
    proxython -c "from kmc import kmc;print(kmc.API().decrypt(0))"
    unset ENCRYPT_DATA
}

function start_haproxy_with_key()
{
    local cfg_path=$1
    local pid_path=$2
    local key=$(get_password)
    /usr/bin/expect<<-EOF
    set timeout 600
    spawn /usr/sbin/haproxy -D -f "${cfg_path}" -p "${pid_path}"
    expect {
        "Enter PEM pass phrase:" {
            send {${key}}
            send "\r"
        }
        eof
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function reload_haproxy_with_key()
{
    local cfg_path=$1
    local pid_path=$2
    local pid=$3
    local key=$(get_password)
    /usr/bin/expect<<-EOF
    set timeout 600
    spawn /usr/sbin/haproxy -D -f "${cfg_path}" -p "${pid_path}" -sf ${pid}
    expect {
        "Enter PEM pass phrase:" {
            send {${key}}
            send "\r"
        }
        eof
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function check_haproxy_with_key()
{
    local cfg_path=$1
    local key=$(get_password)
    /usr/bin/expect<<-EOF
    set timeout 600
    spawn /usr/sbin/haproxy -c -f ${cfg_path} -q
    expect {
        "Enter PEM pass phrase:" {
            send {${key}}
            send "\r"
        }
        eof
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}
