#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi

CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_PATH})))
source ${LINE_ROOT}/bin/utils.sh
source ${CURRENT_PATH}/haproxy_utils.sh
HAPROXY_ROOT_PATH='/opt/huawei-data-protection/agentproxy/services/haproxy'
LOG_TAG="haproxyControl"

#generate config file
log_info "Begin to generate haproxy config file."
/usr/bin/cp -f ${HAPROXY_ROOT_PATH}/haproxy_global.cfg ${HAPROXY_ROOT_PATH}/haproxy_tmp.cfg
CHECK_RESULT $? "Cache haproxy config failed."

# finsh replace config file
/usr/bin/cp -f ${HAPROXY_ROOT_PATH}/haproxy_tmp.cfg ${HAPROXY_ROOT_PATH}/haproxy_global.cfg
CHECK_RESULT $? "replace  haproxy  config failed."

#reload haproxy
log_info "Begin to reload haproxy config file."
reload_haproxy_with_key "${HAPROXY_ROOT_PATH}/haproxy_global.cfg" "${HAPROXY_ROOT_PATH}/haproxy.pid"  $(cat "${HAPROXY_ROOT_PATH}/haproxy.pid")
CHECK_RESULT $? "Reload haproxy failed."
log_info "Refresh haproxy config file finished."
