#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"

CFG_PATH="/opt/huawei-data-protection/agentproxy/conf/haproxy"
CERTS_PATH="/opt/huawei-data-protection/agentproxy/certs/haproxy"
LOG_PATH="/var/log/huawei-data-protection/agentproxy/services/haproxy"
TOOL_DIR="/opt/huawei-data-protection/agentproxy/tools/haproxy"

function stop_service()
{
    log_info "Begin to stop haproxy ..."
    if [ -f "/usr/bin/haproxyControl" ];then
        haproxyControl -S STOP
        if [ $? -ne 0 ];then
            log_error "Stop haproxy failed."
            exit 1
        fi
    fi
    log_info "Stop haproxy finished."
}

function uninstall_rpm()
{
    rpm_num=`rpm -qa|grep haproxyreg|grep -v grep|wc -l`
    if [ ${rpm_num} -gt 0 ];then
        rpm -e haproxyreg --nodeps
    fi
}

function uninstall_files()
{
    log_info "Remove links of haproxy..."
    rm -f /usr/bin/haproxyControl
    if [[ $# -eq 0 ]];then
        all_dir=(
            ${CFG_PATH}
            ${CERTS_PATH}
            ${LOG_PATH}
            ${TOOL_DIR}
        )
    else
        all_dir=(
            ${CFG_PATH}
            ${CERTS_PATH}
            ${TOOL_DIR}
        )
    fi
    for cur_dir in "${all_dir[@]}"
    do
        log_info "Remove directory ${cur_dir}..."
        rm -rf ${cur_dir}
        if [ $? -ne 0 ];then
            log_error "Remove directory ${cur_dir} failed."
        fi
    done
}

function main()
{
    log_info "Begin to uninstall haproxy..."
    stop_service
    uninstall_rpm
    uninstall_files $1
    log_info "Uninstall haproxy successfully."
}

main $1
