#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}
source /opt/huawei-data-protection/agentproxy/inst/bin/utils.sh
LOG_TAG="haArb"

function key_tool_encrypt()
{
    local keytool="/usr/local/bin/ha/ha/module/hacom/tools/key-tool"
    local cipher_mode=0
    if [[ "`get_info.py cipher_type`" != "generalCipher" ]];then
        cipher_mode=1
    fi
    local arb_conf=`get_info.py arb_path`
    local encrypt_pwd=`echo ${pas2wd} | ${keytool} -a ${cipher_mode} -i | grep 'Encrypted' | awk -F: '{print \$NF}' | tr -d ' '`
    if [ "${encrypt_pwd}" = "" ]; then
        echo_error "Encrypt password by key-tool failed..."
        exit 1
    fi
    sed -i '/arb.password=/d' ${arb_conf}
    sed -i "4i arb.password=${encrypt_pwd}" ${arb_conf}
    log_info "Encrypt password by key-tool successful..."
}

if [ $# -ne 1 ];then
    echo_error "Please input correct parameter..."
    exit 1
fi

read -s enc_pwd
export ENCRYPT_DATA=${enc_pwd}
pas2wd=$(proxython -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")
unset ENCRYPT_DATA
key_tool_encrypt
