#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"

function start_zookeeper()
{
    echo_info "begin start $1..."
    fail_count=0
    while [ ${fail_count} -lt 3 ]; do
        sudo -u agentproxy bash /usr/local/bin/$1/apache-zookeeper/bin/zkServer.sh start
        if [[ $? -eq 0 ]]; then
            echo_info "Start $1 success..."
            return 0
        fi
        let ++fail_count
        log_warn "Start $1 failed, fail_count=${fail_count}..."
        sleep 10
    done
    echo_error "Start $1 failed..."
    exit 1
}

main()
{
    start_zookeeper zookeeper
    local zk_nodes=($(get_info.py zookeeper_nodes | sed 's/,/ /g'))
    local manage_ip=$(get_info.py manage_ip)
    if [[ "${zk_nodes[0]}" == "${manage_ip}" ]];then
        start_zookeeper v_zookeeper
    fi
}

main
