#!/bin/bash

ZOO_CFG="/usr/local/bin/zookeeper/apache-zookeeper/conf/zoo.cfg"
V_ZOO_CFG="/usr/local/bin/v_zookeeper/apache-zookeeper/conf/zoo.cfg"
MANAGE_IP=$(get_info.py manage_ip)
VZK_DATA_PORT=$(get_info.py v_zookeeper_data_port)
VZK_ELECTION_PORT=$(get_info.py v_zookeeper_election_port)
ZK_NODES=($(get_info.py zookeeper_nodes | sed 's/,/ /g'))


function config_zookeeper()
{
    sed -i '/server.3/ d ' ${ZOO_CFG}

    if [[ "$1" == "active" ]]; then
        echo "server.3=${MANAGE_IP}:${VZK_DATA_PORT}:${VZK_ELECTION_PORT}" >> ${ZOO_CFG}
    else
        if [[ "${ZK_NODES[0]}" == "${MANAGE_IP}" ]];then
            echo "server.3=${ZK_NODES[1]}:${VZK_DATA_PORT}:${VZK_ELECTION_PORT}" >> ${ZOO_CFG}
        else
            echo "server.3=${ZK_NODES[0]}:${VZK_DATA_PORT}:${VZK_ELECTION_PORT}" >> ${ZOO_CFG}
        fi
    fi
}

function config_vzookeeper()
{
    if [[ "$1" == "active" ]]; then
        sed -i '/server.3/ d ' ${V_ZOO_CFG}
        echo "server.3=${MANAGE_IP}:${VZK_DATA_PORT}:${VZK_ELECTION_PORT}" >> ${V_ZOO_CFG}
    fi
}

function main()
{
    if [ $# -lt 2 ]; then
        exit 1
    fi
    case "$1" in
        zookeeper)
            config_zookeeper $2
        ;;
        v_zookeeper)
            config_vzookeeper $2
        ;;
        *)
            exit 1
        ;;
    esac
    echo "config zookeeper succ."
}

main "$@"
