#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
LOG_DIR="/var/log/huawei-data-protection/agentproxy/services/zookeeper"
SRC_DIR="/usr/local/bin/zookeeper"
V_SRC_DIR="/usr/local/bin/v_zookeeper"
TOOL_DIR="/opt/huawei-data-protection/agentproxy/tools/zookeeper"

function stop_service()
{
    log_info "Begin to stop $1..."
    fail_count=0
    while [ ${fail_count} -lt 3 ]; do
        sudo -u agentproxy bash /usr/local/bin/$1/apache-zookeeper/bin/zkServer.sh stop
        if [[ $? -eq 0 ]]; then
            echo_info "Stop $1 success..."
            return 0
        fi
        let ++fail_count
        log_warn "Stop $1 failed, fail_count=${fail_count}..."
        sleep 10
    done
    echo_error "Stop $1 failed..."
    exit 1
}

function uninstall_files()
{
    log_info "Remove links of zookeeper..."
    rm -f /usr/bin/zookeeperControl
    rm -f /usr/bin/v_zookeeperControl
    rm -f /usr/bin/configZookeeper
    if [[ $# -eq 0 ]];then
        all_dir=(
            ${SRC_DIR}
            ${V_SRC_DIR}
            ${LOG_DIR}
            ${TOOL_DIR}
        )
    else
        all_dir=(
            ${SRC_DIR}
            ${V_SRC_DIR}
            ${TOOL_DIR}
        )
    fi
    for cur_dir in "${all_dir[@]}"
    do
        log_info "Remove directory ${cur_dir}..."
        rm -rf ${cur_dir}
        if [ $? -ne 0 ];then
            log_error "Remove directory ${cur_dir} failed."
        fi
    done
}

function main()
{
    log_info "Begin to uninstall zookeeper..."
    stop_service zookeeper
    stop_service v_zookeeper
    uninstall_files $1
    log_info "Uninstall zookeeper successfully."
}

main $1
