import glob
import os
import shutil
import subprocess
import sys

import six

from cinder.backup import ebackupconfig

kmc_lib_path = "/usr/lib64/kmcadaptor"


def remove_file(file_path):
    if os.path.exists(file_path):
        os.remove(file_path)


def whether_not_exist(file_path):
    if not os.path.exists(file_path):
        return True
    else:
        return False


def uninstall_driver_rpm(install_path):
    if not install_path:
        cinder_install_path = ebackupconfig.get_install_path_slient()
    else:
        cinder_install_path = install_path
    rm_cmd = ['rm', '-f'] + glob.glob(f'{cinder_install_path}/eBackup-cinder*.rpm')
    subprocess.run(rm_cmd, shell=False)

    ret = 0
    final_process = subprocess.Popen(['/usr/bin/rpm', '-qa'], stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                                     stderr=subprocess.PIPE)
    final_process = subprocess.Popen(['/usr/bin/grep', 'eBackup'], stdin=final_process.stdout, stdout=subprocess.PIPE,
                                     stderr=subprocess.PIPE)
    stdout, std_err = final_process.communicate(timeout=50)
    ebackup_rpms = stdout.decode("utf-8").strip(os.linesep).split(os.linesep)
    for ebackup_rpm in ebackup_rpms:
        ret = subprocess.run(["/usr/bin/rpm", "-e", ebackup_rpm], shell=False).returncode
        print(f"Finish uninstall {ebackup_rpm}")
    print("Uninstall finish")
    sys.exit(ret)


def clear_conf_silent():
    cps_user = os.environ['CPS_USERNAME']
    cps_pass = os.environ['CPS_PASSWORD']
    dmkconfiger = ebackupconfig.DmkConfig(cps_user, '', cps_password=cps_pass)
    dmkconfiger.uninstall_all_parameters()


def uninstall_BackupDriver():
    ebackupconfig.set_log('uninstall eBackup driver start.')
    while True:
        choose = six.moves.input('Do you want to uninstall eBackup driver? (y/n)(default:n):')
        if choose == 'Y' or choose == 'y' or choose == 'N' or choose == 'n' or choose == '':
            if choose == '':
                choose = 'N'
            break

    if choose == 'Y' or choose == 'y':
        cps_user, cps_pass = ebackupconfig.set_env_var()
        cinder_install_path = ebackupconfig.get_install_path()

        # uninstall driver
        hwdriver_pyfile = cinder_install_path + 'drivers/hwsebackup.py'
        hwdriver_roll_file = cinder_install_path + 'drivers/hwsebackup.hwroll'
        hwdriver_agent_roll_file = cinder_install_path + 'drivers/ebackupagent.hwroll'
        version_roll_file = cinder_install_path + 'drivers/version.hwroll'
        ebkversion_roll_file = cinder_install_path + 'drivers/ebackupversion.hwroll'
        context_roll_file = cinder_install_path + 'drivers/ebackupconst.hwroll'
        ebackupversion_file = cinder_install_path + 'drivers/ebackupversion.hwroll'
        ebackupconfig_roll_file = cinder_install_path + 'ebackupconfig.hwroll'
        context_hwroll_file = cinder_install_path + 'drivers/context.hwroll'
        primary_keystore_file = "/home/openstack/primary_keystore.dat"
        standby_keystore_file = "/home/openstack/standby_keystore.dat"
        primary_kmc_cfg_file = "/home/openstack/primary_kmc_cfg.conf"
        standby_kmc_cfg_file = "/home/openstack/standby_kmc_cfg.conf"
        upgrade_bak_conf = cinder_install_path + 'ebackup_conf.bak'
        backup_dir = cinder_install_path + 'ebackup_driver_backup'

        # ===================check driver whether has been installed====================
        if whether_not_exist(hwdriver_pyfile):
            print('The eBackup driver has not been installed!')
            return False

        remove_file(hwdriver_roll_file)
        remove_file(hwdriver_agent_roll_file)
        remove_file(version_roll_file)
        remove_file(ebkversion_roll_file)
        remove_file(context_roll_file)
        remove_file(ebackupversion_file)
        remove_file(ebackupconfig_roll_file)
        remove_file(context_hwroll_file)
        remove_file(primary_keystore_file)
        remove_file(standby_keystore_file)
        remove_file(primary_kmc_cfg_file)
        remove_file(standby_kmc_cfg_file)
        if os.path.exists(kmc_lib_path):
            shutil.rmtree(kmc_lib_path)

        while True:
            choose = six.moves.input(
                'Do you want to clear the configuration information that is shared by all eBackup drivers in the system?(y/n)(default:n):')
            if (choose == 'Y' or choose == 'y' or choose == 'N' or choose == 'n' or choose == ''):
                if choose == '':
                    choose = 'N'
                break

        if choose == 'Y' or choose == 'y':
            while True:
                choose = six.moves.input(
                    'If other eBackup drivers in the system are using the configuration information, this operation will cause the configuration information to be unavailable for other eBackup driver nodes. \nAre you sure you want to continue?(y/n)(default:n):')
                if (choose == 'Y' or choose == 'y' or choose == 'N' or choose == 'n' or choose == ''):
                    if choose == '':
                        choose = 'N'
                    break
            if choose == 'Y' or choose == 'y':
                dmkconfiger = ebackupconfig.DmkConfig(cps_user, '', cps_password=cps_pass)
                dmkconfiger.uninstall_all_parameters()
        remove_file(upgrade_bak_conf)
        if os.path.exists(backup_dir):
            shutil.rmtree(backup_dir)
        uninstall_driver_rpm(cinder_install_path)
    else:
        print('quit uninstall.')

    ebackupconfig.set_log('uninstall eBackup driver finish.')


if __name__ == '__main__':
    if len(sys.argv) == 2 and sys.argv[1] == 'clear_conf_silent':
        clear_conf_silent()
    elif len(sys.argv) == 2 and sys.argv[1] == 'uninstall_silent':
        uninstall_driver_rpm('')
    else:
        uninstall_BackupDriver()
