import json
import time
import functools
import logging
from six.moves import http_client
from six import PY3
if PY3:
    import urllib.request as url_lib
else:
    import urllib2 as url_lib


logger = logging.getLogger('__EBACKUP_CONFIG__')


class BoundHTTPsHandler(url_lib.HTTPSHandler):
    def __init__(self, source_address=None, debuglevel=0):
        url_lib.HTTPSHandler.__init__(self, debuglevel)
        self.https_class = functools.partial(http_client.HTTPSConnection,
                                             source_address=source_address)

    def https_open(self, req):
        return self.do_open(self.https_class, req)


class HttpConnection(object):
    """ http restful based"""

    def __init__(self, clientip='', retrytimes=0, retryinterval=30):
        self.clientip = clientip
        self.retrytimes = retrytimes
        self.retryinterval = retryinterval

    @staticmethod
    def update_header(request, headers):
        for key in headers:
            request.add_header(key, headers[key])

    def request(self, method, url, headers, body=None):
        retrytimes = self.retrytimes
        logger.debug("REQUEST:%s %s" % (method,url))
        while retrytimes >= 0:
            try:
                proxy = url_lib.ProxyHandler({})
                if not self.clientip:
                    opener = url_lib.build_opener(proxy)
                else:
                    handler = BoundHTTPsHandler(source_address=(self.clientip, 0))
                    opener = url_lib.build_opener(handler, proxy)
                if body:
                    bodystr = json.dumps(body)
                else:
                    bodystr = ''
                if PY3:
                    bodystr = bodystr.encode('utf-8')
                req = url_lib.Request(url, bodystr)
                HttpConnection.update_header(req, headers)
                if method == 'put':
                    req.get_method = lambda: 'PUT'
                elif method == 'delete':
                    req.get_method = lambda: 'DELETE'
                elif method == 'get':
                    req.get_method = lambda: 'GET'
                response = opener.open(req, timeout=60)
                resbody = response.read()
                if PY3:
                    return response.info()._headers, resbody
                return response.info().dict, resbody

            except Exception:
                if retrytimes > 0:
                    time.sleep(self.retryinterval)
                    retrytimes -= 1
                else:
                    raise
