import os
import sys
import logging
import base64

import six

if six.PY3:
    import subprocess as commands
else:
    import commands as commands

logger = logging.getLogger('__EBACKUP_CONFIG__')
logger.setLevel(level=logging.DEBUG)
logger.propagate = False
logger.handlers = []

log_file_path = os.path.abspath(__file__ + '/../dmk_driver.log')
handler = logging.FileHandler(log_file_path)
handler.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s [%(levelname)s] at %(filename)s,%(lineno)d: %(message)s')
handler.setFormatter(formatter)
logger.addHandler(handler)
g_current_path = os.path.abspath(__file__ + '/../')
g_repo_path = os.path.abspath(g_current_path + "/../repo")


def get_install_path(rollback=False):
    default_install_path = ''
    if rollback and os.path.isdir('/usr/lib/python3.7/site-packages/cinder/backup/'):
        return '/usr/lib/python3.7/site-packages/cinder/backup/'
    if os.path.isfile('/usr/lib/python/site-packages/cinder/backup/__init__.py'):
        default_install_path = \
            '/usr/lib/python/site-packages/cinder/backup/'
    elif os.path.isfile('/usr/lib/python3.7/site-packages/cinder/backup/__init__.py'):
        default_install_path = \
            '/usr/lib/python3.7/site-packages/cinder/backup/'
    elif os.path.isfile('/usr/lib/python2.7/site-packages/cinder/backup/__init__.py'):
        default_install_path = \
            '/usr/lib/python2.7/site-packages/cinder/backup/'
    elif os.path.isfile('/usr/lib64/python2.7/site-packages/cinder/backup/__init__.py'):
        default_install_path = \
            '/usr/lib64/python2.7/site-packages/cinder/backup/__init__.py'
    elif os.path.isfile(
            '/opt/cloud/services/cascading-cinder/venv/lib/'
            'python2.7/site-packages/cinder/backup/__init__.py'):
        default_install_path = \
            '/opt/cloud/services/cascading-cinder/venv/lib/' \
            'python2.7/site-packages/cinder/backup/'
    else:
        logger.info('Can not get default path.')
        # if cinder manager is not exist, the path is wrong.
        logger.info('Incorrect path. Please check it.')
        return ""
    return default_install_path


def get_python_path():
    python_path = 'python2.7'
    (ret, _) = commands.getstatusoutput(
        "python --version | grep 'Python 3' 1>/dev/null")
    if 0 == ret:
        python_path = '/usr/bin/python3'
    else:
        if os.path.exists('/opt/cloud/services/cinder/venv/bin/python2.7'):
            python_path = '/opt/cloud/services/cinder/venv/bin/python2.7'
        elif os.path.exists(
                '/opt/cloud/services/cascading-cinder/venv/bin/python2.7'):
            python_path = \
                '/opt/cloud/services/cascading-cinder/venv/bin/python2.7'
    return python_path
    
g_python_path = get_python_path()
g_cinder_install_path = get_install_path()
g_parameter_ini = g_current_path + '/../vars/main.yml'
g_config_script = g_cinder_install_path + 'ebackupconfig.py'
g_cps_user_name = ''
g_cps_password = ""

def is_existed_ebackup_driver():
    return os.path.exists(g_cinder_install_path + 'drivers/ebackupversion.conf')


def get_version_by_config(conf_path_name):
    if not os.path.exists(conf_path_name):
        logger.error("There is no " + conf_path_name)
        return ""
    os.system("dos2unix " + conf_path_name + " >/dev/null")
    cmds = "grep -w eBackupVersion %s | awk -F '=' '{print $2}'" % conf_path_name
    (ret, version) = commands.getstatusoutput(cmds)
    if 0 != ret:
        logger.error("Get version by ebackupversion.conf failed.")
        return ""
    return version


def get_version_by_rpm(rpm_path_name):
    if not os.path.exists(rpm_path_name):
        logger.error("There is no " + rpm_path_name)
        return ""
    try:
        rmp_name = rpm_path_name.split('/')[-1]
        version = rmp_name.split('-')[4]
        return version
    except Exception as e:
        logger.error("Get version by rpm name failed.The reason is:" + str(e))
        return ""


def check_role(cps_username, cps_password):
    file_name = os.path.abspath(__file__ + '/../queryDriverNodes.py')
    check_role_cmd = 'echo "%s" | "%s" "%s" "%s" "check_role"' % (
        cps_password, g_python_path, file_name, cps_username)
    ret = (0 == os.system(check_role_cmd))
    return ret

def install(cps_username, cps_password):
    try:
        logger.info("Begin to install eBackup driver.")
        # step1 check role
        is_true = check_role(cps_username, cps_password)
        if not is_true:
            logger.info("This node is not a eBackup driver node.")
            print("This node is not a eBackup driver node.")
            return True

        (ret, rpm_name) = commands.getstatusoutput('ls %s/ | grep "eBackup-cinder-backup-driver"' % g_repo_path)
        if 0 != ret:
            logger.error("Find rpm failed in " + g_repo_path)
        rpm_path_name = g_repo_path + '/' + rpm_name

        # step2 check driver file
        if not is_existed_ebackup_driver():
            ret = os.system("%s %s/install.py install_silent %s" %(g_python_path, g_current_path, rpm_path_name))
            if 0 != ret:
                logger.error("Install eBackup driver failed.")
                return False
            logger.info("Install eBackup driver successfully.")
            return True

        # step check version
        current_version = get_version_by_config(g_cinder_install_path + 'drivers/ebackupversion.conf')
        logger.info("The current version is " + current_version)
        pkg_version = get_version_by_config(g_current_path + '/cinder/backup/drivers/ebackupversion.conf')
        logger.info("The pkg version is " + pkg_version)
        if current_version == pkg_version:
            logger.info("The current version is latest version.No need to installl")
            return True
        else:
            logger.error("eBackup driver has been installed at the node,the current version is {}.".format(current_version))
            print("Error: eBackup driver has been installed at the node,the current version is {}.".format(current_version))
            return False
    except Exception as e:
        logger.info("Install eBackup driver failed.The reason is: " + str(e))
        return False


def upgrade(cps_username, cps_password):
    try:
        logger.info("Begin to upgrade eBackup driver.")
        # step1 check role
        is_true = check_role(cps_username, cps_password)
        if not is_true:
            logger.info("This node is not a eBackup driver node.")
            print("This node is not a eBackup driver node.")
            return True

        (ret, rpm_name) = commands.getstatusoutput('ls %s/ | grep "eBackup-cinder-backup-driver"' % g_repo_path)
        if 0 != ret:
            logger.error("Find rpm failed in " + g_repo_path)
        rpm_path_name = g_repo_path + '/' + rpm_name

        # step2 check driver file
        if not is_existed_ebackup_driver():
            ret = os.system("%s %s/install.py install_silent %s" % (g_python_path, g_current_path, rpm_path_name))
            if 0 != ret:
                print("Upgrade eBackup driver failed.")
                logger.error("Upgrade eBackup driver failed.")
                return False
            logger.info("Upgrade eBackup driver successfully.")
            return True

        # step check version
        current_version = get_version_by_config(g_cinder_install_path + 'drivers/ebackupversion.conf')
        logger.info("The current version is " + current_version)
        pkg_version = get_version_by_config(g_current_path + '/cinder/backup/drivers/ebackupversion.conf')
        logger.info("The pkg version is " + pkg_version)
        if current_version == pkg_version:
            logger.info("The current version is latest version.No need to installl")
            return True
        else:
            ret = os.system("%s %s/backup.py" % (g_python_path, g_current_path))
            if 0 != ret:
                print("Backup self failed.")
                logger.error("Backup self failed.")
                return False
            ret = os.system("%s %s/install.py install_silent %s" %(g_python_path, g_current_path, rpm_path_name))
            if 0 != ret:
                print("Upgrade eBackup driver failed.")
                logger.error("Upgrade eBackup driver failed.")
                return False
            logger.info("Install eBackup driver successfully.")
            return True
    except Exception as e:
        logger.info("Install eBackup driver failed.The reason is: " + str(e))
        return False


def uninstall():
    logger.info("Begin to uninstall eBackup driver.")
    if is_existed_ebackup_driver():
        ret = os.system("%s %s/uninstall.py uninstall_silent" % (g_python_path, g_current_path))
        if 0 != ret:
            logger.error("Uninstall eBackup driver failed.")
            return False
    else:
        logger.info("There is no eBackup driver.")
    logger.info("Uninstall eBackup driver successfully.")
    return True

def CheckIPv4(ip):
    return os.system("echo %s | egrep '^\s*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])$\s*' >/dev/null 2>&1" % ip)
def CheckIPv6(ip):
    cmd = "echo " + ip +  "| egrep '^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:)))?\s*$' >/dev/null 2>&1"
    return os.system(cmd)
def CheckIp(ip):
    if CheckIPv4(ip) == 0 or CheckIPv6(ip) == 0:
        return 0
    return 1

def configItem(interface, item, value, section):
    if value != '' and value != 'NULL':
        if item == "ebackup_login_password_v2" \
                or item == "ebackup_storage_username_v2"\
                or item == "ebackup_storage_password_v2 ":
            cmd = 'echo "%s %s" | %s %s %s %s %s %s' % (
                g_cps_password, value, g_python_path, g_config_script,
                interface, g_cps_user_name, item, section)
        else:
            cmd = 'echo "%s" | %s %s %s %s %s %s %s' % (
                g_cps_password, g_python_path, g_config_script, interface,
                g_cps_user_name, item, value, section)
        if os.system(cmd) != 0:
            print("Error:Fail to %s %s(%s)!" % (interface, item, value))
            exit(1)
    return 0


def cfgeBackupServerSectionParam():
    PhysicalNetworkTypes= commands.getoutput("cat %s | grep -w 'PhysicalNetworkType:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    FusionStorageIps= commands.getoutput("cat %s | grep -w 'FusionStorageIp:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    FusionStorageAgentIps= commands.getoutput("cat %s | grep -w 'FusionStorageAgentIp:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    Lazyloading = commands.getoutput("cat %s | grep -w 'Lazyloading:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    ebkIps = commands.getoutput("cat %s | grep -w 'Ipaddr:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    azs = commands.getoutput("cat %s | grep -w 'Azs:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    ebkUsers = commands.getoutput("cat %s | grep -w 'LoginUser:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    ebkPwds = commands.getoutput("cat %s | grep -w 'PasswordUsr:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    ports = commands.getoutput("cat %s | grep -w 'Port:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    certFilePath = commands.getoutput("cat %s | grep -w 'CertFilePath:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    configMode = commands.getoutput("cat %s | grep -w 'configMode:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    extend = commands.getoutput("cat %s | grep -w 'Extend:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    tenant_list = commands.getoutput("cat %s | grep -w 'Tenant_list:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    EnEncrypt = commands.getoutput("cat %s | grep -w 'EnEncrypt:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    ApiGatewayHost = commands.getoutput("cat %s | grep -w 'ApiGatewayHost:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    ApiGatewayCaFile = commands.getoutput("cat %s | grep -w 'ApiGatewayCaFile:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)

    # check the parameters
    ebkIp_array = ebkIps.split(',')
    az_array = azs.split(',')
    ebkUser_array = ebkUsers.split(',')
    ebkPwd_array = ebkPwds.split(',')
    port_array = ports.split(',')
    cert_array = certFilePath.split(',')
    extend_array = extend.split(',')
    tenant_list_array = tenant_list.split(',')
    if PhysicalNetworkTypes != '':
        networkType_array = PhysicalNetworkTypes.split(',')
    FSIp_array = FusionStorageIps.split(',')
    FSAgentIp_array = FusionStorageAgentIps.split(',')
    if int(configMode) != 0 and int(configMode) != 1:
        print("Error:configMode must be 0 or 1.")
        return 1
    if EnEncrypt == 'True' and (ApiGatewayHost == '' or ApiGatewayCaFile == ''):
        print("Error:api_gateway_host and api_gateway_ca_file can not be None when EnEncrypt is True.")
        return 1

    if len(ebkIp_array) == 0 or len(ebkUser_array) == 0 or len(ebkPwd_array) == 0:
        print("Error:some parameter is None,please check the parameters such as Ipaddr,LoginUser,PasswordUsr.")
        return 1

    if len(ebkUser_array) != len(ebkPwd_array):
        print("Error:the number of LoginUser and PasswordUsr must be the same.")
        return 1
    if len(ebkIp_array) != len(ebkUser_array) and len(ebkUser_array) != 1:
        print("Error:If all servers have the same LoginUser and PasswordUsr,you just need input a set of username and password.Otherwise,you must input the username and password for every server!")
        return 1
    if len(port_array) != 0 and len(ebkIp_array) != len(port_array) and len(port_array) != 1:
        print("Error:If all servers use the same port,you just need input one port only.Otherwise,you must input a port for every server!")
        return 1
    if len(cert_array) != 0 and len(ebkIp_array) != len(cert_array) and len(cert_array) != 1:
        print("Error:If all servers use the same CertFilePath,you just need input one CertFilePath only.Otherwise,you must input a CertFilePath for every server!")
        return 1

    for ip in ebkIp_array:
        if CheckIp(ip) != 0:
            print("Error:Ipaddr(%s) is invalid!" % ip)
            return 1
    # step1 start config driver
    cmd = g_python_path + " " + g_config_script + " start"
    if os.system(cmd) != 0:
        logger.error("Start eBackupServer config failed!")
        print("Error:Start eBackupServer config failed!")
        return 1

    if Lazyloading == "1" or Lazyloading == "2":
        if FusionStorageIps == '' or FusionStorageAgentIps == '':
            print("Error:When Lazyloading is 1 or 2,FusionStorageIp and FusionStorageAgentIp can not be NULL!")
            return 1
        for ip in FSIp_array:
            if ip == "NULL":
                continue
            if CheckIp(ip) != 0:
                print("Error:FusionStorageIp(%s) is invalid!" % ip)
                return 1
        for ips in FSAgentIp_array:
            ip_array = ips.split('|')
            for ip in ip_array:
                if ip == "NULL":
                    continue
                if CheckIp(ip) != 0:
                    print("Error:FusionStorageIp(%s) is invalid!" % ip)
                    return 1
    if PhysicalNetworkTypes != '':
        for type in networkType_array:
            if type == "NULL":
                continue
            if type != "ib" and type != "ip":
                print("Error:PhysicalNetworkType(%s) is invalid!" % type)
                return 1
    # config parameter
    index = 0
    while index < len(ebkIp_array):
        ip = ebkIp_array[index]
        az = commands.getoutput("echo '%s' | sed 's/|/,/g'" % az_array[index])
        if PhysicalNetworkTypes != '':
            netType = networkType_array[index]

        if Lazyloading == "1" or Lazyloading == "2":
            fsIP = FSIp_array[index]
            agentIPs = commands.getoutput("echo '%s' | sed 's/|/,/g'" % FSAgentIp_array[index])
        user=""
        userPwd=""
        port=""
        cert=""

        if len(ebkUser_array) == 1:
            user = ebkUser_array[0]
            userPwd = ebkPwd_array[0]
        else:
            user = ebkUser_array[index]
            userPwd = ebkPwd_array[index]
        if len(port_array) == 1:
            port = port_array[0]
        else:
            port = port_array[index]
        if len(cert_array) == 1:
            cert = cert_array[0]
        else:
            cert = cert_array[index]
        if six.PY3:
            pwd = base64.b64encode(bytes(userPwd, encoding='utf-8')).decode(encoding="utf-8")
        else:
            pwd = base64.b64encode(userPwd)

        configItem('update', 'ebackup_server_ip', ip, ip)
        configItem('update', 'ebackup_login_password_v2', pwd, ip)
        configItem('update', 'ebackup_login_username', user, ip)
        configItem('update', 'ebackup_server_port', port, ip)
        configItem('update', 'ebackup_login_crt', cert, ip)
        if int(configMode) == 0:
            configItem('append', 'azs', az, ip)
        else:
            configItem('update', 'azs', az, ip)
        if PhysicalNetworkTypes != '':
            configItem('update', 'physical_network_type', netType, ip)
        if Lazyloading == "1" or Lazyloading == "2":
            configItem('update', 'fusion_storage_ip', fsIP, ip)
            configItem('update', 'fusion_storage_agent_ip', agentIPs, ip)
        
        if index >= len(extend_array):
            extendStatus="False"
            tenantList=""
        else:
            extendStatus = extend_array[index]
            tenantList = tenant_list_array[index]
            tenantList = tenantList.replace('|', ',')

        if extendStatus == 'True' and tenantList != '':
            configItem('update', 'extend', extendStatus, ip)
            configItem('update', 'tenant_white_list', tenantList, ip)
        else:
            configItem('update', 'extend', "False", ip)
        index += 1

    return 0


def cfgDefaultSection():
    section = 'default'
    # default is public
    configItem('update', 'ebackup_env_type', '1', section)
    vbs_adminAK = commands.getoutput("cat %s | grep -w 'vbs_adminAK:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    vbs_adminSK = commands.getoutput("cat %s | grep -w 'vbs_adminSK:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    if vbs_adminAK != '' and vbs_adminSK != '':
        if six.PY3:
            enAK = base64.b64encode(bytes(vbs_adminAK, encoding='utf-8')).decode(encoding="utf-8")
            enSK = base64.b64encode(bytes(vbs_adminSK, encoding='utf-8')).decode(encoding="utf-8")
        else:
            enAK = base64.b64encode(vbs_adminAK)
            enSK = base64.b64encode(vbs_adminSK)

        configItem('update', 'ebackup_storage_username_v2', enAK, section)
        configItem('update', 'ebackup_storage_password_v2', enSK, section)

    defaultSection = {('ebackup_bucket_name','S3BucketPrefix'),('ebackup_storage_s3_protocol','S3Protocol'),('ebackup_storage_unit_path','S3Ipaddr'),('ebackup_uds_data_layout','S3DataLayout'),('ebackup_lazyloading','Lazyloading'),('ebackup_nova_ecs_api','ebackup_nova_ecs_api'),('ebackup_nova_endpoint','ebackup_nova_endpoint')}
    for dst, src in defaultSection:
        value = commands.getoutput("cat %s | grep -w %s: | awk -F ':' '{print $2}' | sed 's/ //g'" % (g_parameter_ini, src))
        configItem('update', dst, value, section)

    EnEncrypt = commands.getoutput("cat %s | grep -w 'EnEncrypt:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    ApiGatewayHost = commands.getoutput("cat %s | grep -w 'ApiGatewayHost:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    ApiGatewayCaFile = commands.getoutput("cat %s | grep -w 'ApiGatewayCaFile:' | awk -F ':' '{print $2}' | sed 's/ //g'" % g_parameter_ini)
    if EnEncrypt == 'True' and ApiGatewayHost != '' and ApiGatewayCaFile != '':
        configItem('update', 'ApiGatewayHost', ApiGatewayHost, section)
        configItem('update', 'ApiGatewayCaFile', ApiGatewayCaFile, section)
    return 0



def configeBackupDriver(cps_username, cps_password):
    global g_cps_user_name
    g_cps_user_name = cps_username
    if cps_username == '' or cps_password == '':
        logger.error("cps_username or cps_password is empty!")
        print("Error:cps_username or cps_password is empty!")
        return False

    if cfgeBackupServerSectionParam() != 0:
        logger.error("configeBackupParameter failed.")
        return False
    if cfgDefaultSection() != 0:
        logger.error("cfgDefaultSection failed.")
        return False
    # check eBackupServer config
    cmd = "echo '%s'| %s %s check %s" % (cps_password, g_python_path, g_config_script, g_cps_user_name)
    if os.system(cmd) != 0:
        logger.error("Check eBackupServer config failed!")
        print("Error:Check eBackupServer config failed!")
        return False
    # commit eBackupServer config
    
    cmd = "echo '%s'| %s %s commit %s" % (cps_password, g_python_path, g_config_script, g_cps_user_name)
    if os.system(cmd) != 0:
        logger.error("Commit eBackupServer config failed!")
        print("Error:Commit eBackupServer config failed!")
        return False
    return True

def config(cps_username, cps_password):
    try:
        logger.info("Begin to config eBackup driver.")

        # step1 check driver file
        if not is_existed_ebackup_driver():
            logger.info("There is no eBackup driver in this node,no need to rollback.")
            print("There is no eBackup driver in this node.")
            return True
        
        # step2 config driver
        if not configeBackupDriver(cps_username, cps_password):
            logger.error("config eBackup driver failed.")
            print("config eBackup driver failed.")
            return False
        return True
    except Exception as e:
        logger.error("Config eBackup driver failed.The reason is: " + str(e))
        return False


def rollback():
    try:
        logger.info("Begin to rollback eBackup driver.")
        if not is_existed_ebackup_driver():
            logger.info("There is no eBackup driver,no need to rollback.")
            return True

        current_version = get_version_by_config(g_cinder_install_path + 'drivers/ebackupversion.conf')
        logger.debug("Current version is " + current_version)
        rpm_path_name = g_repo_path + "/" + commands.getoutput('ls %s/ | grep "eBackup-cinder-backup-driver"' % g_repo_path)
        pkg_version = get_version_by_config(g_current_path + '/cinder/backup/drivers/ebackupversion.conf')
        logger.debug("Pkg version is " + pkg_version)
        if pkg_version != current_version:
            logger.info("The version is old version.No need to rollback.")
            return True
        else:
            backup_path = get_install_path(True) + "/" + "ebackup_driver_backup/"
            if not os.path.exists(backup_path):
                logger.info("There is no backup file.Rollback means uninstall it.")
                return uninstall()

            ret = os.system('%s %s/rollback.py rollback_file' % (g_python_path, g_current_path))
            if 0 != ret:
                logger.error("Rollbackup eBackup driver failed.")
                return False
            logger.info("Rollback eBackup driver by installing successfully.")
            return True
    except Exception as e:
        logger.error("Rollback eBackup driver failed.The reason is: " + str(e))


def check_password(cps_username, cps_password):
    from queryDriverNodes import check_cps_admin_password
    try:
        logger.info("Begin to check cps password.")
        if six.PY3:
            cps_password = str(base64.b64decode(cps_password), encoding='utf-8')
        else:
            cps_password = base64.b64decode(cps_password)
        is_true = check_cps_admin_password(cps_username, cps_password)
        if not is_true:
            logger.error("Check the password of the %s user failed." % cps_username)
            return False
        logger.info("Check cps password pass.")
        return True
    except Exception as e:
        logger.error("Decode the password of the cps_admin user failed.Description:" + str(e))
        return False


def clear_config(cps_username, cps_password):
    try:
        logger.info("Begin to clear eBackup driver config.")
        if six.PY3:
            cps_password = str(base64.b64decode(cps_password), encoding='utf-8')
        else:
            cps_password = base64.b64decode(cps_password)
        clear_conf = 'export CPS_USERNAME={0} && export CPS_PASSWORD={1} && '.format(cps_username, cps_password) + \
                           '{0} {1}/uninstall.py clear_conf_silent'.format(g_python_path, g_current_path)
        ret = os.system(clear_conf)
        if 0 != ret:
            logger.error("Clear eBackup driver config failed.")
            return False
        logger.info("Clear eBackup driver config successfully.")
        return True
    except Exception as e:
        logger.info("Clear eBackup driver config failed.The reason is " + str(e))


def sync_config(cps_username, cps_password):
    try:
        sync_config_cmd = "echo '%s' | %s %s/ebackupconfig.py  sync %s" % (
            cps_password, g_python_path, g_cinder_install_path, cps_username)
        if 0 != os.system(sync_config_cmd):
            logger.error("Sync eBackup driver config failed.")
            return False
        logger.info("Sync eBackup driver config successfully.")
        return True
    except Exception as e:
        logger.error("Sync eBackup driver config failed.The reason is: " + str(e))
        return False


if __name__ == '__main__':
    if sys.argv.__len__() != 3:
        logger.error("Parameter is Invalid.")
        print("ERROR: Parameter is Invalid.")
        exit(1)
    cps_username = sys.argv[1]
    cps_password = six.moves.input()
    g_cps_password = cps_password
    action = sys.argv[2]
    valid_actions = ['install', 'upgrade', 'uninstall', 'rollback', 'rollback_config', 'clear_config', 'check_password', 'config', 'sync_config']
    if action not in valid_actions:
        logger.error("Action is invalid.")
        print("ERROR: Action is invalid.The valid operation are:" + str(valid_actions))
        exit(1)

    if action == 'install':
        is_true = install(cps_username, cps_password)
        if not is_true:
            print("ERROR: Install eBackup driver failed.")
            exit(1)
        print("Install eBackup driver successfully.")
    elif action == 'upgrade':
        is_true = upgrade(cps_username, cps_password)
        if not is_true:
            print("ERROR: Upgrade eBackup driver failed.")
            exit(1)
        print("Upgrade eBackup driver successfully.")
    elif action == 'uninstall':
        is_true = uninstall()
        if not is_true:
            print("ERROR: Uninstall eBackup driver failed.")
            exit(1)
        print("Uninstall eBackup driver successfully.")

    elif action == 'rollback':
        is_true = rollback()
        if not is_true:
            print("ERROR: Rollback eBackup driver failed.")
            exit(1)
        print("Rollback eBackup driver successfully.")
    elif action == 'rollback_config':
        is_true = True
        if not is_true:
            print("ERROR: Rollback eBackup driver failed.")
            exit(1)
        print("Rollback eBackup driver successfully.")
    elif action == 'check_password':
        is_true = check_password(cps_username, cps_password)
        if not is_true:
            print("ERROR: The password of the cps_admin is wrong.")
            exit(1)
        print("Check password of the cps_admin successfully.")
    elif action == 'clear_config':
        is_true = clear_config(cps_username, cps_password)
        if not is_true:
            print("ERROR: Clear eBackup driver config failed.")
            exit(1)
        print("Clear eBackup driver config successfully.")
    elif action == 'config':
        is_true = config(cps_username, cps_password)
        if not is_true:
            print("ERROR: Config eBackup driver failed.")
            exit(1)
        print("Config eBackup driver successfully.")
    elif action == 'sync_config':
        is_true = sync_config(cps_username, cps_password)
        if not is_true:
            print("ERROR: Sync eBackup driver config failed.")
            exit(1)
        print("Sync eBackup driver config successfully.")
    exit(0)
