#!/bin/bash
SDK_ROOT_DIR=$(cd "$(dirname "$0")";pwd)
SDK_ROOT_DIR="${SDK_ROOT_DIR}/../"
SDK_VARS_FILE_DIR="${SDK_ROOT_DIR}/vars"
G_PYTHON_PATH=""
G_CPS_USER_NAME=""
G_CPS_PASSWORD=""
G_CONFIG_SCRIPT=""
G_DEFAULT_INSTALL_PATH=""

function is_existed_ebackup_driver()
{
    if [ -d "/usr/lib/python3.7/site-packages/cinder/backup/" ]
    then
        G_DEFAULT_INSTALL_PATH="/usr/lib/python3.7/site-packages/cinder/backup/"
    elif [ -d "/usr/lib/python2.7/site-packages/cinder/backup" ]
    then
        G_DEFAULT_INSTALL_PATH="/usr/lib/python2.7/site-packages/cinder/backup/"
    elif [ -d "/usr/lib64/python2.7/site-packages/cinder/backup" ]
    then
        G_DEFAULT_INSTALL_PATH="/usr/lib64/python2.7/site-packages/cinder/backup/"
    elif [ -d "/opt/cloud/services/cascading-cinder/venv/lib/python2.7/site-packages/cinder/backup" ]
    then
        G_DEFAULT_INSTALL_PATH="/opt/cloud/services/cascading-cinder/venv/lib/python2.7/site-packages/cinder/backup/"
    else
        echo "can not get default driver path."
    fi
    if [ -f "${G_DEFAULT_INSTALL_PATH}drivers/ebackupversion.conf" ]
    then
        return 0
    fi
    return 1
}

function start()
{
    echo "start success"
}

function stop()
{
    echo "stop success"
}

function online()
{
    echo "online success"
}

function offline()
{
    echo "offline success"
}

function initGlobalVar()
{
    python --version | grep 'Python 3' 1>/dev/null
    if [ $? -eq 0 ]
    then
        G_PYTHON_PATH="/usr/bin/python3"
    else
        ls /opt/cloud/services/cinder/venv/bin/python2.7 >/dev/null 2>&1
        if [ $? -ne 0 ];then
            G_PYTHON_PATH="python2.7"
        else
            G_PYTHON_PATH="/opt/cloud/services/cinder/venv/bin/python2.7"
        fi
    fi
    if [ -f ${SDK_VARS_FILE_DIR}/main.yml ];then
        dos2unix ${SDK_VARS_FILE_DIR}/main.yml >/dev/null 2>&1
    else
        echo "the main.yml file is not exsit."
        return 1
    fi
    G_CPS_USER_NAME=`cat ${SDK_VARS_FILE_DIR}/main.yml | grep -w "CpsUsername:" | awk -F ":" '{print $2}' | sed 's/ //g'`
    local CpsPassword=`cat ${SDK_VARS_FILE_DIR}/main.yml | grep -w "CpsPasswd:" | awk -F ":" '{print $2}' | sed "s/'//g" | sed 's/ //g'`
    if [[ "X${G_CPS_USER_NAME}" == "X" || "X${CpsPassword}" == "X" ]];then
        echo "the CpsUsername or CpsPassword is empty."
        return 1
    fi

    if [ "${G_PYTHON_PATH}" = "/usr/bin/python3" ]
    then
        local pwd=$(${G_PYTHON_PATH} <<-EOF
import base64;print(base64.b64encode(bytes('${CpsPassword}', encoding="utf-8")).decode(encoding="utf-8"));
EOF)
    else
        local pwd=$(${G_PYTHON_PATH} <<-EOF
import base64;print base64.b64encode('${CpsPassword}');
EOF)
    fi
    G_CPS_PASSWORD=${pwd}
    if [ "X${G_CPS_PASSWORD}" = "X" ]
    then
        echo "base64.b64encode CpsPassword failed."
        return 1
    fi
    G_CONFIG_SCRIPT=${SDK_ROOT_DIR}/action/actions.py
    return 0
}

function configKeyList()
{
    local keylist_file="/etc/FSSecurity/keylist.ini"
    sed -i '/ebackup_login_password_v2/d' "${keylist_file}" 
    sed -i '/ebackup_storage_username_v2/d' "${keylist_file}" 
    sed -i '/ebackup_storage_password_v2/d' "${keylist_file}" 
    sed -i '/\[default\]/a ebackup_login_password_v2\nebackup_storage_username_v2\nebackup_storage_password_v2' "${keylist_file}"
    return $?
}

function install()
{
    sed -i 's/"//g' ${SDK_VARS_FILE_DIR}/main.yml
    initGlobalVar
    ret=$?
    if [ ${ret} -ne 0 ];then
        echo "fail to init global var."
        return 1
    fi
  
    configKeyList
    if [ $? -ne 0 ];then
        echo "config key list failed."
        return 1
    fi
    
    is_existed_ebackup_driver
    is_exist=$?
    compare_version=3
    if [ $is_exist -eq 0 ]
    then
        dos2unix "${G_DEFAULT_INSTALL_PATH}/drivers/ebackupversion.conf"
        current_version=`grep -w eBackupVersion "${G_DEFAULT_INSTALL_PATH}drivers/ebackupversion.conf" | awk -F '=' '{print $2}'`
        pkg_version=`grep -w eBackupVersion   "${SDK_ROOT_DIR}/action/cinder/backup/drivers/ebackupversion.conf" | awk -F '=' '{print $2}'`
        echo "current version:$current_version, sdk package version:$pkg_version."
        compare_version=$(python <<-EOF
print 1 if "$current_version" < "$pkg_version" else 2 if "$current_version" > "$pkg_version" else 0;
EOF)

        if [ "$compare_version" = "1" ]
        then
            local action="upgrade"
            ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${G_CPS_USER_NAME} ${G_CPS_PASSWORD} ${action}
            ret=$?
            if [ ${ret} -ne 0 ];then
                echo "fail to upgrade driver."
                return 1
            fi
        elif [ "$compare_version" = "2" ]
        then
            rpm_name=`ls "${G_DEFAULT_INSTALL_PATH}/ebackup_driver_backup/" | grep "eBackup-cinder-backup-driver"`
            if [ "$rpm_name" != "" ]
            then
                ${G_PYTHON_PATH} ${SDK_ROOT_DIR}/action/install.py install_silent  "${G_DEFAULT_INSTALL_PATH}/ebackup_driver_backup/${rpm_name}"
                if [ $? -ne 0 ]
                then
                    echo "rollback eBackup driver failed."
                    return 1
                fi
                echo "rollback eBackup driver by copy file successfully."
            else
                ${G_PYTHON_PATH} ${SDK_ROOT_DIR}/action/rollback.py rollback_file
                if [ $? -ne 0 ]
                then
                    echo "rollback eBackup driver failed."
                    return 1
                fi
                echo "rollback eBackup driver by copy file successfully."
            fi
            return 0
        else
            echo "The current version is latest version, no need to installl."
        fi
    else
        echo "driver version file is not exist, will install driver."
        local action="install"
        ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${G_CPS_USER_NAME} ${G_CPS_PASSWORD} ${action}
        ret=$?
        if [ ${ret} -ne 0 ];then
            echo "fail to install driver."
            return 1
        fi
    fi
    
    if [ $is_exist -eq 0 ]
    then
        if [ "$compare_version" = "1" ]
        then
            local action="sync_config"
            ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${G_CPS_USER_NAME} ${G_CPS_PASSWORD} ${action}
            ret=$?
            if [ ${ret} -ne 0 ];then
                echo "fail to sync_config driver."
                return 1
            fi
        elif [ "$compare_version" = "0" ]
        then
            G_DRIVER_CONFIG_NODE=`cat ${SDK_VARS_FILE_DIR}/main.yml | grep -w "DriverConfigNode:" | awk -F ":" '{print $2}' | sed 's/ //g'`
            if [ "$G_DRIVER_CONFIG_NODE" != "" ]
            then
                ifconfig external_om | grep -w "$G_DRIVER_CONFIG_NODE"
                if [ $? -eq 0 ]
                then
                    echo "config driver on $G_DRIVER_CONFIG_NODE."
                    action="config"
                    ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${G_CPS_USER_NAME} ${G_CPS_PASSWORD} ${action}
                    ret=$?
                    if [ ${ret} -ne 0 ];then
                        echo "fail to config driver."
                        return 1
                    fi
                fi
            else
                echo "DriverConfigNode is empty, will not config driver."
            fi
        fi
    else
        G_DRIVER_CONFIG_NODE=`cat ${SDK_VARS_FILE_DIR}/main.yml | grep -w "DriverConfigNode:" | awk -F ":" '{print $2}' | sed 's/ //g'`
        if [ "$G_DRIVER_CONFIG_NODE" != "" ]
        then
            ifconfig external_om | grep -w "$G_DRIVER_CONFIG_NODE"
            if [ $? -eq 0 ]
            then
                echo "config driver on $G_DRIVER_CONFIG_NODE."
                action="config"
                ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${G_CPS_USER_NAME} ${G_CPS_PASSWORD} ${action}
                ret=$?
                if [ ${ret} -ne 0 ];then
                    echo "fail to config driver."
                    return 1
                fi
            fi
        else
            echo "DriverConfigNode is empty, will not config driver."
        fi
    fi
    return 0
}


function config()
{
    initGlobalVar
    ret=$?
    if [ ${ret} -ne 0 ];then
        echo "fail to init global var."
        return 1
    fi

    action="config"
    ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${G_CPS_USER_NAME} ${G_CPS_PASSWORD} ${action}
    if [ ${ret} -ne 0 ];then
        echo "fail to config driver."
        return 1
    fi
    return 0
}

function uninstall()
{
    sed -i 's/"//g' ${SDK_VARS_FILE_DIR}/main.yml
    initGlobalVar
    ret=$?
    if [ ${ret} -ne 0 ];then
        echo "fail to init global var."
        return 1
    fi
    G_UNINSTALL_DRIVER=`cat ${SDK_VARS_FILE_DIR}/main.yml | grep -w "UninstallDriver:" | awk -F ":" '{print $2}' | sed 's/ //g'`
    if [ "${G_UNINSTALL_DRIVER}" = "1" ]
    then
        ${G_PYTHON_PATH}  ${G_CONFIG_SCRIPT} ${G_CPS_USER_NAME} ${G_CPS_PASSWORD} "uninstall"
        ret=$?
        if [ ${ret} -ne 0 ];then
            echo "fail to uninstall driver."
            return 1
        fi
    fi
    return 0
}

function check_status()
{
    echo "check_status success"
}

function rollback()
{
    echo "rollback success"
}


function main()
{

    local ACTION=$1

    case "$ACTION" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    online)
        online
        ;;
    offline)
        offline
        ;;
    install)
        install
        ;;
    uninstall)
        uninstall
        ;;
    check_status)
        check_status
        ;;
    rollback)
        rollback
        ;;
    config)
        config
        ;;
    *)
        ;;
    esac
}

main $*
exit $?


