import glob
import logging
import os
import shutil
import subprocess
import sys

from cinder.backup import ebackupconfig

logger = logging.getLogger('__EBACKUP_CONFIG__')


def remove_file(file_path):
    logger.debug("remove_file start. file_path: %s" % file_path)
    if os.path.exists(file_path):
        os.remove(file_path)


def copy_file(src_file, drt_file):
    logger.debug("copy_file start. src: %s , dest: %s " % (src_file, drt_file))
    if not os.path.exists(src_file):
        logger.error('source file is not exist, update failed.')
        sys.exit(1)
    if os.path.exists(drt_file):
        logger.debug('remove %s' % drt_file)
        os.remove(drt_file)
    shutil.copyfile(src_file, drt_file)


def backup_old_version():
    logger.info("backup_old_version start.")
    cinder_install_path = ebackupconfig.get_install_path_slient()
    '''installed file'''
    installed_files = ['drivers/hwsebackup.py', 'drivers/ebackupversion.conf', 'drivers/ebackupconst.py',
                       'drivers/ebackupagent.py', 'ebackupconfig.py', 'ebackupuninstall.py', 'cacert.pem',
                       'ebackup_config.ini', 'lib/cloudtools.py', 'lib/cpsrestful.py', 'lib/httprestful.py',
                       'lib/__init__.py', 'lib/ebackuprestful.py', 'lib/Uranus.py', 'driver_inspect_tool.py',
                       'ebackuprollback.py', 'lib/configlog.py', 'lib/migrate_tool.py']

    '''clean old version backup files'''
    c10_backup_files = ['drivers/hwsebackup.hwroll', 'drivers/ebackupversion.hwroll', 'drivers/ebackupconst.hwroll',
                        'ebackupconfig.hwroll', 'ebackupuninstall.hwroll', 'cacert.hwroll']
    for bak_file in c10_backup_files:
        if os.path.exists(cinder_install_path + bak_file):
            remove_file(cinder_install_path + bak_file)
    '''clean backup files created at last'''
    backup_dir = ebackupconfig.BACKUP_PATH + 'ebackup_driver_backup/'
    if not os.path.exists(backup_dir):
        logger.debug("make backup floder: %s" % backup_dir)
        os.makedirs(backup_dir)
    else:
        subprocess.run(['rm', '-r'] + glob.glob(f'{backup_dir}/*'), shell=False)

    if not os.path.exists(backup_dir + 'drivers'):
        logger.debug("make backup driver floder: %sdrivers" % backup_dir)
        os.makedirs(backup_dir + 'drivers')
    if not os.path.exists(backup_dir + 'lib'):
        logger.debug("make backup lib floder: %slib" % backup_dir)
        os.makedirs(backup_dir + 'lib')

    logger.info("backup installed files")
    '''backup file'''
    for filename in installed_files:
        if os.path.exists(cinder_install_path + filename):
            copy_file(cinder_install_path + filename, backup_dir + filename)

    installed_dirs = ['lib/datastore']
    for dirname in installed_dirs:
        if os.path.exists(cinder_install_path + dirname):
            shutil.copytree(cinder_install_path + dirname, backup_dir + dirname)

    logger.info("backup installed files finish")
    logger.info("backup rpm")
    subprocess.run(['cp', '-f'] + glob.glob(f'{cinder_install_path}/eBackup-cinder-*.rpm') + [backup_dir], shell=False)
    logger.info("backup rpm finished")


def backup_main():
    logger.info("backup eBackup driver start.")
    try:
        backup_old_version()
    except Exception as msg:
        logger.error("backup failed.")
        logger.error(msg)
        sys.exit(1)
    logger.info("backup eBackup driver finish.")


if __name__ == '__main__':
    try:
        backup_main()
    except Exception as e:
        logger.error("backup.py error : %s" % e)
        sys.exit(1)
