import getpass
import json
import os
import re
import stat
import subprocess
import sys

from oslo_utils.uuidutils import is_uuid_like


def _check_bp(brick_path):
    if brick_path and not re.search('^[:a-zA-Z0-9/.,_-]+$', brick_path):
        print('Invalid bp.')
        exit(1)


def _exec_os_cmd(args):
    status, output = subprocess.getstatusoutput(args)
    if status != 0:
        raise Exception(output)
    return output


class DbTool(object):
    def __init__(self, passwd):
        self.passwd = passwd

    def exec_sql(self, sql):
        sql_cmd = f'gsql -U gaussdba -d cinder -W "{self.passwd}" -c "{sql}"'
        return _exec_os_cmd(sql_cmd)

    def update_backup_metadata(self, old_value, new_value):
        update_sql = f"update backups set service_metadata=replace(service_metadata, '{old_value}', '{new_value}') " \
                     f"where deleted='f' and service_metadata like '%{old_value}%';"
        return self.exec_sql(update_sql)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print('\nUsage: python obs_migrate_tools.py [old_bp] [new_bp]\n')
        exit(-1)
    _, old_bp, new_bp = sys.argv
    _check_bp(old_bp)
    _check_bp(new_bp)
    password = getpass.getpass("Please enter the db password:")
    db = DbTool(password)
    ret1 = db.update_backup_metadata(f'\\\"BP\\\":\\\"{old_bp}\\\"', f'\\\"BP\\\":\\\"{new_bp}\\\"')
    ret2 = db.update_backup_metadata(f'\\\"BP\\\": \\\"{old_bp}\\\"', f'\\\"BP\\\": \\\"{new_bp}\\\"')
    if ret1 == 'UPDATE 0' and ret2 == 'UPDATE 0':
        print('Migrate failed! There is no related backup, please check the entered parameters.')
        exit(-1)
    print("Migrate successfully!")
