#!/bin/bash
export PATH=$PATH:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/root/bin

G_WORKSPACE=$(cd `dirname $0`;pwd)
function CheckIPv4()
{
    local ipstr=$1

    echo $ipstr|egrep '^\s*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])$\s*' >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
       return 1
    fi
    return 0
}

function CheckIPv6()
{
    local ipstr=$1

    echo $ipstr | egrep '^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:)))?\s*$' >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
       return 1
    fi
    return 0
}

function CheckIp()
{
    local ipstr=$1

    CheckIPv4 ${ipstr} || CheckIPv6 ${ipstr}

    return $?
}

function ClearEnv()
{
    local WorkPathName="/tmp/upgrade/upgrade_pkg/upgrade"

    if [ -f ${G_WORKSPACE}/UpgradeConfig.txt ]; then
        rm -f ${G_WORKSPACE}/UpgradeConfig.txt
    fi

    return 0
}

function SetBackupStorgeIP()
{
    local L_IpList=""
    L_IpList=`cat "${G_WORKSPACE}/UpgradeConfig.txt" | grep -w "BackupStorageIP" | awk -F "=" '{print $2}' | awk -F "," '{for(i=1; i<=NF; i++) print $i}'`
    if [ -z "$L_IpList" ]
    then
        echo -e "Error:Fail to get BackupStoragePlane IP"
        return 1
    fi
    declare -a IpArray
    
    local index=0
    #1.get BackupStoragePlane IpAddress
    for ip in $L_IpList
    do
        CheckIp ${ip}
        if [ $? -ne 0 ]
        then
            echo -e "Error:The ip(${ip}) is invalid"
            return 1
        fi
        IpArray["$index"]=$ip
        index=$((index+1))
    done

    index=0  
    local IpNum=${#IpArray[*]}
    local IpAddress=
    local MacAddress=
    #2.get BackupStoragePlane MacAddress
    while [ $index -lt $IpNum ]    
    do
        local IpLine=`ifconfig -a 2> /dev/null | grep -nw "${IpArray["$index"]}" | awk -F ":" '{print $1}'`
        if [[ -z "$IpLine" || ! -z $(echo $IpLine | grep '[^[:digit:]]') ]]; then
            index=$((index+1))
            continue
        fi
       
        IpAddress=${IpArray["$index"]}

        local IP_TYPE=4
        echo ${IpAddress} | grep ":" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            #IPv6
            IP_TYPE=6
        fi
        local CardName=`ip -${IP_TYPE} a 2> /dev/null | grep -w "${IpAddress}" | awk '{print $NF}'`
        if [[ -f "/etc/SuSE-release" ]]; then
            MacAddress=`ifconfig ${CardName} 2>/dev/null | grep -w "Ethernet" | grep -w "HWaddr" | awk '{print $5}'`
        fi

        if [[ -f "/etc/euleros-release" ]]; then
            MacAddress=`ifconfig ${CardName} 2>/dev/null | grep -w "Ethernet" | grep -w "ether" | awk '{print $2}'`
        fi

        break       
    done
       
    #3.write BackupStoragePlane info to BackupStoragePlane.txt
    local PlaneInfoFileName=/tmp/upgrade/upgrade_pkg/ms_upgrade/public/BackupStoragePlane.txt

    if [[ -z "${IpAddress}" || -z "${MacAddress}" ]]; then
        echo "Warning:Fail to get the BackupStoragePlane IP or Mac address at the current node."
        
        if [ -f ${PlaneInfoFileName} ]; then
            rm -f ${PlaneInfoFileName}
        fi

        return 1
    fi
    
    echo ";This item include two fields.IP address and MAC address for specify plane.Separate them by '|'" > ${PlaneInfoFileName}
    echo "BackupStoragePlane=${IpAddress}|${MacAddress}" >> ${PlaneInfoFileName}
    echo "BackupStoragePlane=${IpAddress}|${MacAddress}" > ${G_WORKSPACE}/BackupStoragePlane.txt

    return 0
}

function ModifyBackupStorgeIP()
{
    SetBackupStorgeIP
    if [ $? -ne 0 ];then
        echo "[ModifyBackupStorgeIP,$LINENO]Error:Set BackupStorge IP Failed"
        return 1
    fi
    if [ ! -f ${G_WORKSPACE}/BackupStoragePlane.txt ];then
        echo "[ModifyBackupStorgeIP,$LINENO]Error:BackupStoragePlane.txt is not existed."
        return 1
    fi
    local backup_storage_plane=`grep -w "BackupStoragePlane" ${G_WORKSPACE}/BackupStoragePlane.txt`
    local services=("admin" "ebk_mgr" "ebk_alarm"  "ebk_backup"  "ebk_copy"  "ebk_delete"  "ebk_governance"  "ebk_iam"  "ebk_lb"  "ebk_license"  "ebk_openstack_vm"  "ebk_openstack_vmware"  "ebk_restore"  "ebk_vmware")
    local hcp_path="/opt/huawei-data-protection/ebackup/"
    local ret=0
    
    # 1.modify BackupStoragePlane
    for service in "${services[@]}"
    do
        if [[ "${service}x" != "adminx" ]];then
            file="${hcp_path}/microservice/${service}/conf/privateconf.ini"
        else
            file="${hcp_path}/conf/privateconf.ini"
        fi
        
        if [ ! -f ${file} ];then
            echo "There is no ${file}"
            continue
        fi

        grep -w "BackupStoragePlane" ${file} >/dev/null 2>&1
        if [ $? -ne 0 ];then
            echo ";This item include two fields.IP address and MAC address for specify plane.Separate them by '|'" >> ${file}
            echo ";This item will be change when perform initial configuration" >> ${file}
            echo ";Range is IP Class A B C" >> ${file}
            echo ${backup_storage_plane} >> ${file}
        else
            sed -i '/BackupStoragePlane=/ c'$backup_storage_plane'' ${file}
            if [ $? -ne 0 ];then
                ret=1
            fi
        fi
    done
    if [ ${ret} -ne 0 ];then
        echo "[ModifyBackupStorgeIP,$LINENO]modify BackupStorgeIP failed."
        return 1
    fi
    G_HCP_PROCESS_ACCOUNT=hcpprocess
    # 1.restart ebk_copy
    su -s /bin/sh ${G_HCP_PROCESS_ACCOUNT} -c "sh ${hcp_path}/microservice/ebk_copy/script/ebackup_stop.sh"
    if [ $? -ne 0 ];then
        echo "[ModifyBackupStorgeIP,$LINENO]Stop ebk_copy failed."
        return 1
    fi
    
    su -s /bin/sh ${G_HCP_PROCESS_ACCOUNT} -c "sh ${hcp_path}/microservice/ebk_copy/script/ebackup_start.sh"
    if [ $? -ne 0 ];then
        echo "[ModifyBackupStorgeIP,$LINENO]Start ebk_copy failed."
        return 1
    fi

    return 0
}

function usage()
{
    echo "Usage:"
    echo -e "\tsh BackupStoragePlaneCfg.sh SetBackupStorgeIP"
    echo -e "\tSetBackupStorgeIP      --   Config the ip of the BackupStorage plane"
    echo -e "\tModifyBackupStorgeIP   --   Modify the ip of the BackupStorage plane"
}

function main()
{
    local operation=$1
    local ret=
    case "${operation}" in
        SetBackupStorgeIP)
            SetBackupStorgeIP
            ret=$?
            ;;
        ModifyBackupStorgeIP)
            ModifyBackupStorgeIP
            ret=$?
            ;;
        *)
            echo "Error: Unsupported operation!"
            usage
            ret=1
            ;;
    esac

    ClearEnv
    return ${ret}
}
main "$@"
exit $?


