#!/bin/sh
set +x
G_V3_MEMORY_REQUIRE_MIN_SIZE=3996 #1024MB * 4 - 100MB
G_MEMORY_REQUIRE_MIN_SIZE=12188 #1024MB * 12 - 100MB
G_V3_INSTALL_ENVIRONMENT="/etc/env_v3"
G_OS_TYPE="" #操作系统的类型
G_CPU_CORES=4

VMType=
LeaderPublicKey=
S_InternalCommunicationIPInfo=
ManagePlaneNetworkCard=
InternalPlaneNetworkCard=
ProductionManagementNetworkCard=
ProductionStorageNetworkCard=
BackupStorageNetworkCard=

BackupManagementIPList=
InternalCommunicationIPList=
ProductionManagementIPList=
ProductionStorageIPList=
BackupStorageIPList=

SoftWareVersion="8.5.0"
SoftWarePkgName="eBackup_${SoftWareVersion}"

X86SuSEUpgradePkgName="OceanStor BCManager ${SoftWareVersion}_eBackup_Upgrade_SuSE_x86_64.tar.gz"
X86EulerUpgradePkgName="OceanStor BCManager ${SoftWareVersion}_eBackup_Upgrade_Euler_x86_64.tar.gz"
ArmEulerUpgradePkgName="OceanStor BCManager ${SoftWareVersion}_eBackup_Upgrade_Euler_arm64.tar.gz"
SuSEIBDriverPkgName="MLNX_OFED_LINUX-3.2-2.0.0.0-sles11sp3-x86_64-ext_for_2288V3.tgz"
EulerV22IBDriverPkgName="MLNX_OFED_LINUX-4.1-1.0.2.0-euleros2.0sp2-x86_64-ext.tgz"
EulerV23IBDriverPkgName="MLNX_OFED_LINUX-4.3-1.0.1.0-euleros2.0sp3-ext.tgz"

ToolPath=/opt/huawei-data-protection/ebackup/sbin
G_eBackupServer=""
SERVERIDLIST=""
G_scope=0

G_EULER_DEPEN_PKG_LIST="haveged iptables-services libtool-ltdl cifs-utils iscsi-initiator-utils sg3_utils nfs-utils tcl expect bc glibc"
G_EULER_STD_2V2_RELEASE="EulerOS release 2.0 (SP2)"     #Euler2.2标准镜像内核
G_EULER_STD_2V3_RELEASE="EulerOS release 2.0 (SP3)"     #Euler2.3标准镜像内核
G_EULER_STD_2V5_RELEASE="EulerOS release 2.0 (SP5)"     #Euler2.3标准镜像内核

G_REPO_SERVER_DIR="/etc/yum.repos.d"
G_REPO_SERVER_CONF="/etc/yum.repos.d/EulerOS-user.repo"
G_REPO_SERVER_NAME="EulerOS-user"
G_SYSTEM_STRUC=`uname -m`
function write_ebackup_plane_config()
{
    LeaderPublicKey=`cat NetworkPlaneInfo.txt | grep -w "LeaderPublicKey" | awk -F "LeaderPublicKey:" '{print $2}'`
    VMType=`cat NetworkPlaneInfo.txt | grep -w "VMType" | awk -F "=" '{print $2}'`
    if [[ "$VMType" != "0" ]] && [[ "$VMType" != "1" ]]
    then
        echo "VMType is not [0-1]."
        return 1
    fi
    
    S_InternalCommunicationIPInfo=`cat NetworkPlaneInfo.txt | grep -w "PrimaryNode.InternalCommunicationIP" | awk -F "=" '{print $2}' | tr 'A-Z' 'a-z'`
    if [ "${S_InternalCommunicationIPInfo}" = "" ]
    then
        echo "InternalCommunicationIP of primaryNode is empty."
        return 1
    fi
        
    if [ "$VMType" = "0" ]
    then
        ManagePlaneNetworkCard=`cat NetworkPlaneInfo.txt | grep -w "Template.BackupManagementPlane" | awk -F "=" '{print $2}'`
        if [ "${ManagePlaneNetworkCard}" = "" ]
        then
            echo "BackupManagementPlane is empty."
            return 1
        fi
        InternalPlaneNetworkCard=`cat NetworkPlaneInfo.txt | grep -w "Template.InternalCommunicationPlane" | awk -F "=" '{print $2}'`
        if [ "${InternalPlaneNetworkCard}" = "" ]
        then
            echo "InternalCommunicationPlane is empty."
            return 1
        fi
        ProductionManagementNetworkCard=`cat NetworkPlaneInfo.txt | grep -w "Template.ProductionManagementPlane" | awk -F "=" '{print $2}'`
        if [ "${ProductionManagementNetworkCard}" = "" ]
        then
            echo "ProductionManagementPlane is empty."
            return 1
        fi
        ProductionStorageNetworkCard=`cat NetworkPlaneInfo.txt | grep -w "Template.ProductionStoragePlane" | awk -F "=" '{print $2}'`

        BackupStorageNetworkCard=`cat NetworkPlaneInfo.txt | grep -w "Template.BackupStoragePlane" | awk -F "=" '{print $2}'`
    fi

    MatchStr=
    LeaderIP=
    ifconfig -a | grep -w "${S_InternalCommunicationIPInfo}" 1>/dev/null
    if [ $? -eq 0 ]
    then
        MatchStr="PrimaryNode"
    else
        MatchStr="StandbyNode"
        LeaderIP="${S_InternalCommunicationIPInfo}"
    fi

    Role=`cat NetworkPlaneInfo.txt | grep "${MatchStr}.EbackupRole" | awk -F "=" '{print $2}'`
    if [[ "$Role" != "0" ]] && [[ "$Role" != "1" ]] && [[ "$Role" != "2" ]] && [[ "$Role" != "3" ]]
    then
        echo "EbackupRole is not [0-3]."
        return 1
    fi

    if [ "$VMType" != "0" ]
    then
        BackupManagementIPInfo=`cat NetworkPlaneInfo.txt | grep "${MatchStr}.BackupManagementIP" | awk -F "=" '{print $2}' | tr 'A-Z' 'a-z'`
        BackupManagementIPList=`echo $BackupManagementIPInfo | awk -F "," '{for(i=1;i<=NF;i++) print $i}'`
        if [ "$BackupManagementIPList" = "" ]
        then
            echo "split BackupManagementIP(${BackupManagementIPInfo}) string failed."
            return 1
        fi

        InternalCommunicationIPInfo=`cat NetworkPlaneInfo.txt | grep "${MatchStr}.InternalCommunicationIP" | awk -F "=" '{print $2}' | tr 'A-Z' 'a-z'`
        InternalCommunicationIPList=`echo $InternalCommunicationIPInfo | awk -F "," '{for(i=1;i<=NF;i++) print $i}'`
        if [ "$InternalCommunicationIPList" = "" ]
        then
            echo "split InternalCommunicationIP(${InternalCommunicationIPInfo}) string failed."
            return 1
        fi

        ProductionManagementIPInfo=`cat NetworkPlaneInfo.txt | grep "${MatchStr}.ProductionManagementIP" | awk -F "=" '{print $2}' | tr 'A-Z' 'a-z'`
        ProductionManagementIPList=`echo $ProductionManagementIPInfo | awk -F "," '{for(i=1;i<=NF;i++) print $i}'`
        if [ "$ProductionManagementIPList" = "" ]
        then
            echo "split ProductionManagementIP(${ProductionManagementIPInfo}) string failed."
            return 1
        fi

        ProductionStorageIPInfo=
        BackupStorageIPInfo=
        if [[ "$Role" = "0" ]] || [[ "$Role" = "1" ]]
        then
            ProductionStorageIPInfo=`cat NetworkPlaneInfo.txt | grep "${MatchStr}.ProductionStorageIP" | awk -F "=" '{print $2}' | tr 'A-Z' 'a-z'`
            ProductionStorageIPList=`echo $ProductionStorageIPInfo | awk -F "," '{for(i=1;i<=NF;i++) print $i}'`
            if [ "$ProductionStorageIPList" = "" ]
            then
                echo "split ProductionStorageIP(${ProductionStorageIPInfo}) string failed."
                return 1
            fi
            BackupStorageIPInfo=`cat NetworkPlaneInfo.txt | grep "${MatchStr}.BackupStorageIP" | awk -F "=" '{print $2}' | tr 'A-Z' 'a-z'`
            if [ "$BackupStorageIPInfo" != "" ]
            then
                BackupStorageIPList=`echo $BackupStorageIPInfo | awk -F "," '{for(i=1;i<=NF;i++) print $i}'`
            fi
        fi
    else
        ifconfig ${ManagePlaneNetworkCard} 1>/dev/null 2>/dev/null
        if [ $? -ne 0 ]
        then
            echo "network card ${ManagePlaneNetworkCard} is not exist."
            return 1
        fi
        ifconfig ${InternalPlaneNetworkCard} 1>/dev/null 2>/dev/null
        if [ $? -ne 0 ]
        then
            echo "network card ${InternalPlaneNetworkCard} is not exist."
            return 1
        fi
        ifconfig ${ProductionManagementNetworkCard} 1>/dev/null 2>/dev/null
        if [ $? -ne 0 ]
        then
            echo "network card ${ProductionManagementNetworkCard} is not exist."
            return 1
        fi

        if [[ -f "/etc/SuSE-release" ]]; then
            if [ $G_NETWORK_TYPE = 'ipv4' ];then
                ipAddr='inet addr:'
            else
                ipAddr='inet6 addr:'
            fi
            BackupManagementIPList=`ifconfig ${ManagePlaneNetworkCard} | grep "$ipAddr" | awk '{split($2, ipArray, ":"); print ipArray[2]};'`
            InternalCommunicationIPList=`ifconfig ${InternalPlaneNetworkCard} | grep "$ipAddr" | awk '{split($2, ipArray, ":"); print ipArray[2]};'`
            ProductionManagementIPList=`ifconfig ${ProductionManagementNetworkCard} | grep "$ipAddr" | awk '{split($2, ipArray, ":"); print ipArray[2]};'`
            if [[ "$Role" = "0" ]] || [[ "$Role" = "1" ]]
            then
                ProductionStorageIPList=`ifconfig ${ProductionStorageNetworkCard} | grep "$ipAddr" | awk '{split($2, ipArray, ":"); print ipArray[2]};'`
                if [ "$BackupStorageNetworkCard" != "" ]
                then
                    BackupStorageIPList=`ifconfig ${BackupStorageNetworkCard} | grep "$ipAddr" | awk '{split($2, ipArray, ":"); print ipArray[2]};'`
                fi
            fi
        fi
        if [[ -f "/etc/euleros-release" ]]; then
            if [ $G_NETWORK_TYPE = 'ipv4' ];then
                ipAddr="inet"
                BackupManagementIPList=`ifconfig ${ManagePlaneNetworkCard} | grep -w 'inet' | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                InternalCommunicationIPList=`ifconfig ${InternalPlaneNetworkCard} | grep -w 'inet' | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                ProductionManagementIPList=`ifconfig ${ProductionManagementNetworkCard} | grep -w 'inet' | awk '{split($0, ipArray, " "); print ipArray[2]};'`
            else
                ipAddr="inet6"
                BackupManagementIPList=`ifconfig ${ManagePlaneNetworkCard} | grep -w 'inet6' | grep -w 'global' | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                InternalCommunicationIPList=`ifconfig ${InternalPlaneNetworkCard} | grep -w 'inet6' | grep -w 'global' | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                ProductionManagementIPList=`ifconfig ${ProductionManagementNetworkCard} | grep -w 'inet6' | grep -w 'global' | awk '{split($0, ipArray, " "); print ipArray[2]};'`
            fi
            
            if [[ "$Role" = "0" ]] || [[ "$Role" = "1" ]]
            then    
                if [ $G_NETWORK_TYPE = 'ipv4' ];then
                    ProductionStorageIPList=`ifconfig ${ProductionStorageNetworkCard} | grep -w "inet" | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                    if [ "$BackupStorageNetworkCard" != "" ] 
                    then    
                        BackupStorageIPList=`ifconfig ${BackupStorageNetworkCard} | grep -w "inet" | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                    fi      
                else    
                    ProductionStorageIPList=`ifconfig ${ProductionStorageNetworkCard} | grep -w "inet6" | grep -w 'global'| awk '{split($0, ipArray, " "); print ipArray[2]};'`
                    if [ "$BackupStorageNetworkCard" != "" ] 
                    then    
                        BackupStorageIPList=`ifconfig ${BackupStorageNetworkCard} | grep -w "inet6" | grep -w 'global' | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                    fi      
                fi
            fi
        fi
    fi

    FloatingIPInfo=`cat NetworkPlaneInfo.txt | grep "PrimaryNode.FloatingIP" | awk -F "=" '{print $2}' | tr 'A-Z' 'a-z'`

    RoleName=
    if [ "$Role" = "0" ]
    then
        RoleName="BackupServer"
    elif [ "$Role" = "1" ]
    then
        RoleName="BackupProxy"
    elif [ "$Role" = "2" ]
    then
        RoleName="BackupManager"
    elif [ "$Role" = "3" ]
    then
        RoleName="BackupWorkflow"
    fi
    
    sed -i "s/^NetworkType=.*$/NetworkType=$G_NETWORK_TYPE/g" eBackup_Config.ini
    sed -i "s/^EbackupRole=.*$/EbackupRole=$RoleName/g" eBackup_Config.ini
    if [ $? -ne 0 ]
    then
        echo "write EbackupRole info to eBackup_Config.ini error"
        return 1
    fi

    sed -i "s/^FloatingIP=.*$/FloatingIP=$FloatingIPInfo/g" eBackup_Config.ini
    if [ $? -ne 0 ]
    then
        echo "write FloatingIP info to eBackup_Config.ini error"
        return 1
    fi
    
    sed -i '$d' eBackup_Config.ini
    echo "LeaderPublicKey=$LeaderPublicKey" >> eBackup_Config.ini

    if [ "$LeaderIP" != "" ]
    then
        sed -i "s/^LeaderIP=.*$/LeaderIP=$LeaderIP/g" eBackup_Config.ini
        if [ $? -ne 0 ]
        then
            echo "write LeaderIP info to eBackup_Config.ini error"
            return 1
        fi
    fi

    IPList=
    if [ $G_NETWORK_TYPE = 'ipv4' ];then
        if [[ -f "/etc/SuSE-release" ]]; then
			ipaddr='inet addr'
        elif [[ -f "/etc/euleros-release" ]]; then
            ipaddr='inet'
        fi
    else
        if [[ -f "/etc/SuSE-release" ]]; then
            ipaddr='inet6 addr'
        elif [[ -f "/etc/euleros-release" ]]; then
            ipaddr='inet6'
        fi 
    fi
	IPList=`ifconfig -a | grep -w "$ipaddr" | awk '{print $2}'`
    
    if [ "$IPList" = "" ]
    then
        echo "get ip info failed."
        return 1
    fi

    PlaneList=
    PlaneName=
    NUM=1
    SUM=3
    if [[ "$Role" = "0" ]] || [[ "$Role" = "1" ]]
    then
        SUM=5
    fi

    while [ $NUM -le $SUM ]
    do
        if [ $NUM -eq 1 ]
        then
            PlaneList=$BackupManagementIPList
            PlaneName="BackupManagementIP"
        elif [ $NUM -eq 2 ]
        then
            PlaneList=$InternalCommunicationIPList
            PlaneName="InternalCommunicationIP"
        elif [ $NUM -eq 3 ]
        then
            PlaneList=$ProductionManagementIPList
            PlaneName="ProductionManagementIP"
        elif [ $NUM -eq 4 ]
        then
            PlaneList=$ProductionStorageIPList
            PlaneName="ProductionStorageIP"
        elif [ $NUM -eq 5 ]
        then
            PlaneList=$BackupStorageIPList
            PlaneName="BackupStorageIP"
        fi
        for ip in $PlaneList
        do
            echo "$IPList" | grep -w "$ip" 1>/dev/null 2>&1
            if [ $? -eq 0 ]
            then
                sed -i "s/^${PlaneName}=.*$/${PlaneName}=$ip/g" eBackup_Config.ini
                if [ $? -ne 0 ]
                then
                    echo "write $PlaneName info to eBackup_Config.ini error"
                    return 1
                fi
                break
            fi
        done
        local configIP=$(cat eBackup_Config.ini | grep "^${PlaneName}=.*$" | awk -F "=" '{print $2}')
        echo "$IPList" | grep -w "$configIP" 1>/dev/null 2>&1
        if [ $? -ne 0 ];then
            echo "The ${PlaneName} information is incorrectly configured, please check it."
            return 1
        fi
        NUM=`expr $NUM + 1`
    done
}

function suse_kernel_check()
{
    if [ -f /etc/SuSE-release ]
    then
        KernelVersion=`uname -a | awk -F' ' '{print $3}'| sed 's/-default//g' | tr -d ".-"`
        if [ "$KernelVersion" != "" -a "$KernelVersion" -lt 3010104779 ]
        then
            return 1
        fi
    fi
}

function config_repo_server()
{
    local L_Repo_Server=$2
    local L_GpgKey=$3

    yum clean all >/dev/null 2>&1
    yum repository-packages $G_REPO_SERVER_NAME list >/dev/null 2>&1
    if [[ $? -eq 0 ]]; then
        cp $G_REPO_SERVER_CONF $G_REPO_SERVER_CONF.bak >/dev/null 2>&1
    fi
    echo "[$G_REPO_SERVER_NAME]" > $G_REPO_SERVER_CONF
    echo "name=$G_REPO_SERVER_NAME" >> $G_REPO_SERVER_CONF
    echo "baseurl=$L_Repo_Server" >> $G_REPO_SERVER_CONF
    echo "enabled=1" >> $G_REPO_SERVER_CONF
    if [[ -n $L_GpgKey ]]; then
        echo "gpgcheck=1" >> $G_REPO_SERVER_CONF
        echo "gpgkey=$L_GpgKey" >> $G_REPO_SERVER_CONF
    else
        echo "gpgcheck=0" >> $G_REPO_SERVER_CONF
    fi

    local repolist=`ls $G_REPO_SERVER_DIR | grep -v $G_REPO_SERVER_NAME`
    for repoconf in $repolist; do
        reponame=`cat $G_REPO_SERVER_DIR/$repoconf | grep name |awk -F "=" '{print $2}'`
        #确保已有repo的配置错误不影响本次配置
        yum-config-manager --save --setopt=$reponame.skip_if_unavailable=true >/dev/null 2>&1
    done
    yum makecache >/dev/null 2>&1
    yum repository-packages $G_REPO_SERVER_NAME list >/dev/null 2>&1
    if [[ $? -ne 0 ]]; then
        return 1
    fi

    rm -f $G_REPO_SERVER_CONF.bak >/dev/null 2>&1
    return 0
}

function necessary_rpm_check()
{
    if [ -f /etc/SuSE-release ]
    then
        rpm -qa | grep "open-iscsi" 1>/dev/null 2>/dev/null
        if [ $? -ne 0 ]
        then
            echo "SuSE_rpm.tar.gz"
            return 0
        fi
        rpm -qa | grep "cifs-utils" 1>/dev/null 2>/dev/null
        if [ $? -ne 0 ]
        then
            echo "SuSE_rpm.tar.gz"
            return 0
        fi
        rpm -qa | grep "haveged"  1>/dev/null 2>/dev/null
        if [ $? -ne 0 ]
        then
            echo "SuSE_rpm.tar.gz"
            return 0
        fi
    elif [ -f /etc/euleros-release ]
    then
        ls /usr/sbin/traceroute > /dev/null 2>&1
        if [[ $? -ne 0 ]]; then
            echo_euler_tar_name
            return 0
        fi
                
        for pkgname in ${G_EULER_DEPEN_PKG_LIST}; do
            RpmNum=`rpm -qa | grep ^"$pkgname" | wc -l`
            if [[ $pkgname == "glibc" ]]
            then
                GlibcCounter=`rpm -qa | grep "^glibc.*2.17-111.h24" | wc -l`
                if [[ $GlibcCounter != 0 ]]
                then
                    echo_euler_tar_name
                    continue
                fi
            elif [[ $pkgname == "iscsi-initiator-utils" || $pkgname == "sg3_utils" ]]; then
                if [[ $RpmNum -ne 2 ]]; then
                    echo_euler_tar_name
                    return 0
                fi
            elif [[ $RpmNum -ne 1 ]]; then
                    echo_euler_tar_name
                    return 0
            fi
        done
    fi
}

function echo_euler_tar_name()
{
    local L_kernel=`cat /etc/euleros-release`
    case $L_kernel in
        $G_EULER_STD_2V2_RELEASE )
            echo "Euler_rpm.tar.gz"
            ;;
        $G_EULER_STD_2V3_RELEASE )
            echo "Euler_2v3_rpm.tar.gz"
            ;;
        $G_EULER_STD_2V5_RELEASE )
            echo "Euler_2v3_rpm.tar.gz"
            ;;
        *)
            echo "NoMatchTar"
            ;;
    esac
}

function yum_install_pkg()
{ 
    local L_Failed_Num=0
    for pkgname in ${G_EULER_DEPEN_PKG_LIST}; do
        RpmNum=`rpm -qa | grep ^"$pkgname" | wc -l`
        if [[ $pkgname == "glibc" ]]
        then
            GlibcCounter=`rpm -qa | grep "^glibc.*2.17-111.h24" | wc -l`
            if [[ $GlibcCounter == 0 ]]
            then
                continue
            fi
        elif [[ $pkgname == "iscsi-initiator-utils" || $pkgname == "sg3_utils" ]]; then
            if [[ $RpmNum -eq 2 ]]; then
                continue
            fi
        elif [[ $RpmNum -eq 1 ]]; then
                continue
        fi
        if [[ $pkgname == "glibc" ]]
        then
            yum upgrade glibc -y > /dev/null 2>&1 
            continue
        fi
        local yumpkgname=`yum repository-packages $G_REPO_SERVER_NAME list $pkgname | grep $G_SYSTEM_STRUC | grep -v Available | awk -F " " '{print $1}'`
        if [[ -z $yumpkgname ]]; then
            L_Failed_Num=$((L_Failed_Num+1))
            continue
        fi
        
        yum install $yumpkgname -y > /dev/null 2>&1 
        if [[ $? -ne 0 ]]; then
            echo "yum install $pkgname failed."
            L_Failed_Num=$((L_Failed_Num+1))
            continue
        fi

        if [[ $pkgname == "haveged" ]]; then
            service haveged start
            if [ $? -ne 0 ]
            then
                echo "start haveged service failed."
                L_Failed_Num=$((L_Failed_Num+1))
                continue
            fi
            chkconfig haveged on
            if [ $? -ne 0 ]
            then
                echo "chkconfig haveged failed."
                L_Failed_Num=$((L_Failed_Num+1))
                continue
            fi
        fi

    done

    return $L_Failed_Num
}

function necessary_rpm_install()
{
    cd ../
    if [ -f /etc/SuSE-release ]
    then
        cd "OceanStor BCManager SuSE_rpm"/"susepatch"
        rpm -Uvh *.rpm --force --nodeps
        cd ..
        rpm -qa | grep "open-iscsi"
        if [ $? -ne 0 ]
        then
            IscsiRpmName=`ls | grep "open-iscsi"`
            rpm -ivh $IscsiRpmName
            if [ $? -ne 0 ]
            then
                echo "install suse open-iscsi rpm failed."
                exit 1
            fi
        fi
        rpm -qa | grep "cifs-utils"
        if [ $? -ne 0 ]
        then
            CifsRpmName=`ls | grep "cifs-utils"`
            rpm -ivh $CifsRpmName
            if [ $? -ne 0 ]
            then
                echo "install suse cifs-utils rpm failed."
                exit 1
            fi
        fi
        rpm -qa | grep "haveged"
        if [ $? -ne 0 ]
        then
            HavegedRpmName=`ls | grep "haveged"`
            rpm -ivh $HavegedRpmName
            if [ $? -ne 0 ]
            then
                echo "install euler haveged failed."
                exit 1
            fi
            service haveged start
            if [ $? -ne 0 ]
            then
                echo "start haveged service failed."
                exit 1
            fi
            chkconfig haveged on
            if [ $? -ne 0 ]
            then
                echo "chkconfig haveged failed."
                exit 1
            fi
        fi
    elif [ -f /etc/euleros-release ]
    then
        local L_Failed_Num=0
        L_Euler_postfix=`echo_euler_tar_name | awk -F "." '{print $1}'`
        cd "OceanStor BCManager $L_Euler_postfix"
        ls /usr/sbin/traceroute > /dev/null 2>&1
        if [[ $? -ne 0 ]]; then
            if [[ -f "traceroute" ]]; then
                cp traceroute /usr/sbin/ > /dev/null
                chmod 700 /usr/sbin/traceroute > /dev/null
            else
                echo "[Error]traceroute not exist."
                L_Failed_Num=$((L_Failed_Num+1))
            fi
        fi

        yum repository-packages $G_REPO_SERVER_NAME list >/dev/null 2>&1
        if [[ $? -eq 0 ]]; then
            yum_install_pkg
            if [[ $? -eq 0 ]]; then
                return $L_Failed_Num
            fi
        fi

        for pkgname in ${G_EULER_DEPEN_PKG_LIST}; do
            RpmNum=`rpm -qa | grep ^"$pkgname" | wc -l`
            if [[ $pkgname == "glibc" ]]
            then
                GlibcCounter=`rpm -qa | grep "^glibc.*2.17-111.h24" | wc -l`
                if [[ $GlibcCounter == 0 ]]
                then
                    continue
                fi
            elif [[ $pkgname == "iscsi-initiator-utils" || $pkgname == "sg3_utils" ]]; then
                if [[ $RpmNum -eq 2 ]]; then
                    continue
                fi
            elif [[ $RpmNum -ge 1 ]]; then
                continue
            fi

            if [[ $pkgname == "iscsi-initiator-utils" || $pkgname == "nfs-utils" || $pkgname == "cifs-utils" ]]; then
                subpath=`echo $pkgname | awk -F "-" '{print $1}'`
            elif [[ $pkgname == "sg3_utils" ]]; then
                subpath=`echo $pkgname | awk -F "_" '{print $1}'`
            fi

            if [[ $pkgname == "iscsi-initiator-utils" || $pkgname == "nfs-utils" || $pkgname == "cifs-utils" || $pkgname == "sg3_utils" ]]; then
                cd $subpath
                rpm -Uvh *.rpm --force --nodeps
                if [[ $? -ne 0 ]]; then
                    echo "[Error]install rpm [$pkgname] failed."
                    L_Failed_Num=$((L_Failed_Num+1))
                fi
                cd ..
                continue
            fi

            if [[ $pkgname == "glibc" ]]
            then
                cd glibc
                rpm -Uvh *.rpm
                if [[ $? -ne 0 ]]; then
                    echo "[Error]install rpm [$pkgname] failed."
                    L_Failed_Num=$((L_Failed_Num+1))
                fi
                cd ..
                continue
            fi

            local RpmPath=`find ./ -name "$pkgname*"`
            rpm -Uvh $RpmPath --force --nodeps
            if [[ $? -ne 0 ]]; then
                echo "[Error]install rpm [$pkgname] failed."
                L_Failed_Num=$((L_Failed_Num+1))
            fi

            if [[ $pkgname == "haveged" ]]; then
                service haveged start
                if [ $? -ne 0 ]
                then
                    echo "start haveged service failed."
                    L_Failed_Num=$((L_Failed_Num+1))
                    continue
                fi
                chkconfig haveged on
                if [ $? -ne 0 ]
                then
                    echo "chkconfig haveged failed."
                    L_Failed_Num=$((L_Failed_Num+1))
                    continue
                fi
            fi
        done

        return $L_Failed_Num
    fi
}

function output_pkg_name()
{
    echo "${SoftWarePkgName}"
    return 0
}

function output_ibpkg_name()
{
    if [ -f /etc/SuSE-release ]
    then
        echo "${SuSEIBDriverPkgName}"
    elif [ -f /etc/euleros-release ]
    then
        euler_release=`cat /etc/euleros-release`
        if [ "${euler_release}" = "EulerOS release 2.0 (SP3)" ];then
            echo "${EulerV23IBDriverPkgName}"
        else
            echo "${EulerV22IBDriverPkgName}"
        fi
    else
        return 1
    fi
    return 0
}

function upgrade_pkg_name()
{
    local cpu_arch=`uname -m`
    if [ -f /etc/SuSE-release ]
    then
        echo "${X86SuSEUpgradePkgName}"
    elif [ -f /etc/euleros-release ]
    then
        if [ x"${cpu_arch}" == x"x86_64" ];then
            echo "${X86EulerUpgradePkgName}"
        else
            echo "${ArmEulerUpgradePkgName}"
        fi
    else
        return 1
    fi
    return 0
}

function output_plane_ip()
{
    local vmtype=$1
    if [ $vmtype -eq 0 ]
    then
        local NetworkCardName=`echo $2 | awk -F ":" '{print $1}'`
        ifconfig ${NetworkCardName} 1>/dev/null 2>/dev/null
        if [ $? -ne 0 ]
        then
            echo "network card ${NetworkCardName} is not exist."
            return 1
        fi
        if [[ -f "/etc/SuSE-release" ]]; then
            ifconfig ${NetworkCardName} | grep "inet addr:" | awk '{split($2, ipArray, ":"); print ipArray[2]};'
        fi
        if [[ -f "/etc/euleros-release" ]]; then
            ifconfig ${NetworkCardName} | grep "inet" | grep -v "inet6" | awk '{split($0, ipArray, " "); print ipArray[2]};'
        fi
    else
        echo $2 | awk -F ":" '{print $2}'
    fi
    return $?
}

function once_again_check()
{
    rpm -qa | grep "oceanstor-ebackup" 1>/dev/null 2>/dev/null
    if [ $? -ne 0 ]
    then
        echo "ebackup is not installed"
        return 0
    fi
    service hcp status 1>/dev/null 2>/dev/null
    if [ $? -ne 0 ]
    then
        echo "ebackup is not configured"
        return 0
    fi
    echo "service hcp is normal"
    return 0
}

function checkout_os_type()
{
	if [[ -f "/etc/SuSE-release" ]]; then
		G_OS_TYPE="SuSE"
	fi

	if [[ -f "/etc/euleros-release" ]]; then
		G_OS_TYPE="Euler"
	fi
}

function space_check()
{
    local L_LEFTSPACE_SIZE=0
    df | grep "/opt$" > /dev/null 2>&1
    if [ $? -eq 0 ];then 
        #have partition /opt
        L_LEFTSPACE_SIZE=`df -BM | grep "/opt$" | awk -F' ' '{print $4}' | sed 's/M//g'`
    else
        #don't have partition /opt
        L_LEFTSPACE_SIZE=`df -BM | grep "/$" | awk -F' ' '{print $4}' | sed 's/M//g'`
    fi

    if [ ${L_LEFTSPACE_SIZE} -lt 1024 ];then
        echo "space_check:Please make sure there are at least 1024MB on /opt."
        return 0
    fi
    echo "space_check:Pass"
    return 0
}

function mem_check()
{
    checkout_os_type
    local L_MEMORY_REQUIRE_MIN_SIZE=0;
    local L_TOTAL_MEM_SIZE=0
    #local L_MEM_SIZE=`dmidecode -t memory | grep -P "^\s*Size: [0-9]" | awk -F' ' '{print $2}'`
    #local L_MEM_TYPE=`dmidecode -t memory | grep -P "^\s*Size: [0-9]" | awk -F' ' '{print $3}'`

    if [ $G_OS_TYPE == "SuSE" ]; then
        local L_MEM_SIZE=`dmidecode -t memory | grep -P "^\s*Size: [0-9]" | awk -F' ' '{print $2}'`
        local L_MEM_TYPE=`dmidecode -t memory | grep -P "^\s*Size: [0-9]" | awk -F' ' '{print $3}'`
    else
        local L_MEM_SIZE=`dmidecode -t memory | grep "^\s*Size: [0-9]" | awk -F' ' '{print $2}'`
        local L_MEM_TYPE=`dmidecode -t memory | grep "^\s*Size: [0-9]" | awk -F' ' '{print $3}'`
    fi

    #multi-memory device
    local L_MEM_CNT=0
    local l_tempsize=0
    L_MEM_TYPE_ARR=($L_MEM_TYPE)
    L_MEM_SIZE_ARR=($L_MEM_SIZE)
    for size in "${L_MEM_SIZE_ARR[@]}"
    do
        if [[ $size =~ ^[0-9]+$ ]];then
            local L_MEM_TMP=`echo ${L_MEM_TYPE_ARR[L_MEM_CNT]} | tr [a-z] [A-Z]`
            if [ "$L_MEM_TMP" = "GB" ];then
                l_tempsize=$((${size} * 1024))
                L_TOTAL_MEM_SIZE=`expr ${L_TOTAL_MEM_SIZE} + ${l_tempsize}`
            elif [ "$L_MEM_TMP" = "MB" ];then
                L_TOTAL_MEM_SIZE=`expr ${L_TOTAL_MEM_SIZE} + ${size}`
            elif [ "$L_MEM_TMP" = "KB" ];then
                l_tempsize=$((${size} / 1024))
                L_TOTAL_MEM_SIZE=`expr ${L_TOTAL_MEM_SIZE} + ${l_tempsize}`
            else
                echo "           mem_check:Check multi-memory device error."
            fi
            L_MEM_CNT=`expr ${L_MEM_CNT} + 1`
        fi
    done

    if [ ${L_TOTAL_MEM_SIZE} -lt ${G_V3_MEMORY_REQUIRE_MIN_SIZE} ];then
        echo "           mem_check:Please make sure there are at least ${G_V3_MEMORY_REQUIRE_MIN_SIZE}MB memory."
        return 0
    elif [[ ${L_TOTAL_MEM_SIZE} -ge ${G_V3_MEMORY_REQUIRE_MIN_SIZE} && ${L_TOTAL_MEM_SIZE} -lt ${G_MEMORY_REQUIRE_MIN_SIZE} ]];then 
        if [ ! -f "${G_V3_INSTALL_ENVIRONMENT}" ];then
            echo "           mem_check:Please make sure there are enough memory capacity,the current installed environment memory capacity:${L_TOTAL_MEM_SIZE}MB(the minimum ${G_V3_MEMORY_REQUIRE_MIN_SIZE}MB in v3 environment,the minimum ${G_MEMORY_REQUIRE_MIN_SIZE}MB in other environment)."
            return 0
        fi
    fi
    echo "           mem_check:Pass"
    return 0
}

#******************************************************************#
# Function: hardware_check
# Description: Check whether exist enough CPU resource
# Input Parameters: N/A
# Returns: N/A
#******************************************************************#
function hardware_check()
{
    local L_CPU_CORES=`lscpu | grep -P "^CPU\(s\):" | awk -F' ' '{print $2}'`
    if [ ${L_CPU_CORES} -lt ${G_CPU_CORES} ];then
        echo "           hardware_check:Please make sure there are at least CPU 4 Cores."
        return 0
    fi
    echo "           hardware_check:Pass"
	return 0
}

function iptables_check()
{
    if [ $G_NETWORK_TYPE = 'ipv4' ];then
        if [ "${G_OS_TYPE}" == "Euler" ];then
            iptablesfile="iptables.service"
        fi
    else
        if [ "${G_OS_TYPE}" == "Euler" ];then
            iptablesfile="ip6tables.service"
        fi
    fi
    if [ ! -f "/usr/lib/systemd/system/$iptablesfile" ]; then
        echo "           iptables_check:Please make sure iptables-service is installed."
        return 0
    fi

    echo "           iptables_check:Pass"
    return 0
}

function pre_install_check()
{
    space_check

    mem_check
    
    hardware_check

	iptables_check
}

function GET_SESSION_TOKEN()
{
   local passwd=$1

   echo -e "$passwd\n$passwd" | ${ToolPath}/SecurityTool dmk post https://${G_eBackupServer}:8088/rest/dev/login '{"scope":'$G_scope',"username":'\"admin\"',"password":"fake_password"}' "Accept:application/json" 2>Session.txt >>Session.txt
   G_Session=`cat Session.txt|grep Set-Cookie:|uniq|awk '{print $3}'| sed 's/;/ /g'|awk '{print $1}'`
   G_ToKen=`cat Session.txt |grep iBaseToken|awk -F , '{print $3}'|sed 's/"//g'|awk -F : '{print $2}'`
   if [ -z $G_ToKen ]
   then
      rm -rf Session.txt
      return  1
   fi
   rm -rf Session.txt
}

function check_HA_Mode()
{
    local lineNum=0
    local floatip=""

    ifconfig|grep mgr >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        return 0
    fi
    lineNum=`ifconfig|grep -n mgr|awk -F : '{print $1}'`
    lineNum=$(($lineNum+1))
    
    

    if [[ -f "/etc/SuSE-release" ]]; then
        if [ $G_NETWORK_TYPE = 'ipv4' ];then
            ip_addr='inet addr'
        else
            ip_addr='inet6 addr'
        fi
        floatip=`ifconfig -a |sed -n ''$lineNum'p'| grep -w "$ip_addr" | awk '{print $2}' | awk -F ":" '{print $2}'|sed 's/ //g'`
    elif [[ -f "/etc/euleros-release" ]]; then
        if [ $G_NETWORK_TYPE = 'ipv4' ];then
            ip_addr='inet'
        else
            ip_addr='inet6'
        fi
        floatip=`ifconfig -a |sed -n ''$lineNum'p' |grep -w "$ip_addr" | awk '{print $2}'|sed 's/ //g'`
    fi
    
    if [ $G_NETWORK_TYPE = 'ipv4' ];then
        G_eBackupServer=${floatip}
    else
        G_eBackupServer="["${floatip}"]"
    fi
       

    return 1
}


function GET_HA_NODE_INDEX()
{
    ${ToolPath}/SecurityTool dmk get https://${G_eBackupServer}:8088/rest/dev/vbackup_server  null  "Accept:application/json\niBaseToken:$G_ToKen\nCookie: language=zh_CN; $G_Session; DEVICE_ID=dev; sessionIdleTime=60000; MACHINEROLE=0; CSRF_IBASE_TOKEN=$G_ToKen" 2>/dev/null  >httprsp.txt
    if [ $? -ne 0 ] 
    then
        rm -rf httprsp.txt >/dev/null 2>&1
        return 1
    fi  
    cat httprsp.txt | awk -F "}" '{for(i=1;i<=NF;i++) print $i}' > tmp.txt
    while read line
    do
        echo "$line" | grep "\"ID\"" 2>/dev/null
        if [ $? -eq 0 ]
        then
            MANAGEMENTIP=`echo "$line" | awk -F "\"MANAGEMENTIP\":\"" '{print $2}'`
            MANAGEMENTIP=`echo "$MANAGEMENTIP" | awk -F "\"" '{print $1}'` 
            LocalMANAGEMENTIP=`cat /opt/huawei-data-protection/ebackup/conf/privateconf.ini| grep HCPManagementPlane| awk -F '=' '{print $2}' | awk -F '|' '{print $1}'`
            StandbyNode=`su -s /bin/sh hcpprocess -c "sh /opt/huawei-data-protection/ebackup/bin/config_omm_ha.sh query" | grep "HaArbLk" | awk -F "-- " '{print $2}' | awk -F ":" '{print $1}'`
            if [ "$MANAGEMENTIP" = "${StandbyNode}" ]
            then
                SERVERIDLIST=`echo "$line" | awk -F "\"ID\":\"" '{print $2}' | awk -F "\"" '{print $1}'`
                rm tmp.txt
                return 0
            fi
        fi
    done < tmp.txt
    return 1
}

function delete_ha_mode()
{
    >ResultFile
    export LD_LIBRARY_PATH=/opt/huawei-data-protection/ebackup/libs:$LD_LIBRARY_PATH
    read -s pwd
    if [ -z $pwd ]
    then
       echo "Error:Password is empty." >>ResultFile
       exit 0
    fi
    check_HA_Mode
    if [ $? -eq 0 ]
    then
        return 0
    else
        GET_SESSION_TOKEN $pwd
        GET_HA_NODE_INDEX
        if [ $? -ne 0 ]
        then
            echo "Info:ha member is null." >>ResultFile
            exit 0
        fi
        ${ToolPath}/SecurityTool dmk put https://${G_eBackupServer}:8088/rest/dev/vbackup_ha/REMOVE '{"SERVERIDLIST":'\"${SERVERIDLIST}\"'}' "Accept:application/json\niBaseToken:$G_ToKen\nCookie: language=zh_CN; $G_Session;DEVICE_ID=dev; sessionIdleTime=60000; MACHINEROLE=0; CSRF_IBASE_TOKEN=$G_ToKen"  2>/dev/null >rsp.txt
        if [ $? -ne 0 ]
        then
            rm -rf rsp.txt >/dev/null 2>&1
            echo "Error:Delete HA member->send restful msg fail,please check the envirement." >>ResultFile
            return 1
        fi
        rspcode=`cat rsp.txt|grep error|sed 's/,/ /g'|awk '{for (i=1;i<=NF;i++)print $i}'|grep code|sed 's/"//g'|sed 's/{//g'|awk -F : '{print $3}'`
        if [ "$rspcode" != "0" ]
        then
            rm -rf rsp.txt >/dev/null 2>&1
            echo "Error:Delete HA member->the response code is $rspcode,please check you params." >>ResultFile
            return 1
        fi
        rm -rf rsp.txt >/dev/null 2>&1
    fi
    TimeOut=600
    Num=0
    while [ $Num -le $TimeOut ]
    do
        HaMode=`su -s /bin/sh hcpprocess -c "sh /opt/huawei-data-protection/ebackup/bin/config_omm_ha.sh query" 2>/dev/null | grep "HaMode" | awk -F " " '{print $2}'`
        if [ "$HaMode" = "single" ]
        then
            ifconfig|grep mgr >/dev/null 2>&1                                            
            if [ $? -eq 1  ]
            then
                break
            fi
        fi
        sleep 1
        Num=`expr $Num + 1`
    done
    if [ $Num -eq $TimeOut ]
    then
        echo "Error:Delete HA member->delete ha member timeout." >>ResultFile
        return 1
    fi
}

function change_gaussdb_wait_time()
{
    sed -i 'N;826a    sed -i "s/TimeOut=180/TimeOut=600/g" create_ms_db.sh' ebackup_utilities.sh
}


function get_ipinfo_SuSE()
{
    local L_OK_IP="$1"
    local L_CARD=""    
    local L_IP_LINE=""
    local L_IP=""
    local L_MASK=""
    local L_CARD_ARRAY=($(/sbin/ifconfig -a 2> /dev/null | grep 'Link enca' | grep -v 'lo'|awk '{print $1}'))
    local L_CARD_NUM=${#L_CARD_ARRAY[@]}
    ((L_CARD_NUM-=1))
    for i in `seq 0 $L_CARD_NUM`
    do
        L_CARD=${L_CARD_ARRAY[$i]}
        L_IP_LINE=`/sbin/ifconfig $L_CARD 2> /dev/null |sed -n 2p`
        L_IP=`echo $L_IP_LINE|awk -F"inet addr:" '{print $2}'|awk '{print $1}'`
        L_MASK=`echo $L_IP_LINE|awk -F"Mask:" '{print $2}'|awk '{print $1}'`
        if [[ -z $L_IP || -z $L_MASK || $L_IP == "127.0.0.1" ]]
        then
            continue
        fi
        if [ "$L_IP" = "$L_OK_IP" ]
        then
            echo "$L_IP/$L_MASK"
            return 0
        fi
    done
    return 1
}

function get_ipinfo_Euler()
{
    local L_OK_IP="$1"
	local L_TMP_FILE="list_eth.tmp" 
    local L_IP=""
    local L_MASK=""
	/sbin/ifconfig -a 2> /dev/null | grep -n 'flags=' | grep 'RUNNING' | grep -v 'lo' | awk '{split($1, ethArray, ":"); print ethArray[1]" "ethArray[2]}' | sort -k 2 > ${L_TMP_FILE}
    if [ $G_NETWORK_TYPE = 'ipv4' ];then
        while read LINE
        do
            #get line index of eth mac addr
            L_ETH_LINE=`echo "${LINE}" | awk '{print $1}'`
            L_ETH_NAME=`echo "${LINE}" | awk '{print $2}'`

            L_NEXT_LINE_IP=`expr ${L_ETH_LINE} + 1`

            L_IS_IP_EXIST=`/sbin/ifconfig -a 2> /dev/null | sed -n "${L_NEXT_LINE_IP}p" | grep "inet" | grep -v "inet6" | wc -l`

            if [ ${L_IS_IP_EXIST} -eq 1 ];then
                L_IP=`/sbin/ifconfig -a 2> /dev/null | sed -n "${L_NEXT_LINE_IP}p" | grep "inet" | grep -v "inet6" | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                L_MASK=`/sbin/ifconfig -a 2> /dev/null | sed -n "${L_NEXT_LINE_IP}p" | grep "inet" | grep -v "inet6" | awk '{split($0, ipArray, " "); print ipArray[4]};'`
            else
                L_IP="127.0.0.1"
                L_MASK="255.255.255.0"
            fi
            if [ "$L_IP" = "$L_OK_IP" ]
            then
                echo "$L_IP/$L_MASK"
                rm ${L_TMP_FILE}
                return 0
            fi
        done < ${L_TMP_FILE}

        if [ -f ${L_TMP_FILE} ];then
            rm ${L_TMP_FILE}
        fi
        return 1
    else
        while read LINE
        do
            #get line index of eth mac addr
            L_ETH_LINE=`echo "${LINE}" | awk '{print $1}'`
            L_ETH_NAME=`echo "${LINE}" | awk '{print $2}'`

            L_NEXT_LINE_IP=`expr ${L_ETH_LINE} + 1`

            L_IS_IP_EXIST=`/sbin/ifconfig -a 2> /dev/null | sed -n "${L_NEXT_LINE_IP}p" | grep "inet6" | wc -l`

            if [ ${L_IS_IP_EXIST} -eq 1 ];then
                L_IP=`/sbin/ifconfig -a 2> /dev/null | sed -n "${L_NEXT_LINE_IP}p" | grep "inet6" | awk '{split($0, ipArray, " "); print ipArray[2]};'`
                l_ip=$(ipv6tofullipv6 $L_IP)
                L_MASK=${l_ip:0:19}
            else
                L_IP="::1"
                L_MASK="::"
            fi
            if [ "$L_IP" = "$L_OK_IP" ]
            then
                echo "$L_IP/64"
                rm ${L_TMP_FILE}
                return 0
            fi
        done < ${L_TMP_FILE}

        if [ -f ${L_TMP_FILE} ];then
            rm ${L_TMP_FILE}
        fi
        return 1
    fi
}

function get_dmk_ipinfo()
{
    local DMK_IP=`netstat -anp 2>/dev/null | grep -E ":8443[[:space:]]" | awk -F ":8443" '{print $1}' | awk '{print $NF}'`
    if [ "$DMK_IP" = "" ]
    then
        echo "get dmk ip failed."
        return 1
    fi
    if [ -f /etc/SuSE-release ]
    then
        get_ipinfo_SuSE $DMK_IP
    elif [ -f /etc/euleros-release ]
    then
        get_ipinfo_Euler $DMK_IP
    fi
}

function open_dmk2ebackup_iptables()
{
    local dmk_ipinfo="$1"
    local eBackup_ipinfo=
    local eBackupIp=`cat eBackup_Config.ini | grep "BackupManagementIP=" | awk -F 'BackupManagementIP=' '{print $2}'`
    if [ "$eBackupIp" = "" ]
    then
        echo "get ebackup management ip failed."
        return 1
    fi
    if [ -f /etc/SuSE-release ]
    then
        eBackup_ipinfo=`get_ipinfo_SuSE $eBackupIp`
    elif [ -f /etc/euleros-release ]
    then
        eBackup_ipinfo=`get_ipinfo_Euler $eBackupIp`
    fi
    if [ $G_NETWORK_TYPE = 'ipv4' ];then
        iptables -D INPUT -s $dmk_ipinfo -d $eBackup_ipinfo -p tcp --dport 22 -j ACCEPT 2>/dev/null
        iptables -I INPUT -s $dmk_ipinfo -d $eBackup_ipinfo -p tcp --dport 22 -j ACCEPT
    else
        ip6tables -D INPUT -s $dmk_ipinfo -d $eBackup_ipinfo -p tcp --dport 22 -j ACCEPT 2>/dev/null
        ip6tables -I INPUT -s $dmk_ipinfo -d $eBackup_ipinfo -p tcp --dport 22 -j ACCEPT
    fi
    return $?
}

function print_route_info()
{
    local L_Failed_Num=0
    local route_tables=`ip rule|grep lookup |awk -F "lookup" '{print $2}'`
    for table in $route_tables; do
        echo [$table]
        ip route ls table $table 2>/dev/null
        if [[ $? -ne 0 ]]; then
            L_Failed_Num=$((L_Failed_Num+1))
        fi
    done
    return $L_Failed_Num
}

function ipv6tofullipv6()
{
    pre_ip_addr=$1
    addr_len=$(echo $1| awk -F "" '{for(i=1;i<=NF;++i) if($i==":") ++sum}END{print sum}')
    case $addr_len in
	8) 
            local location_flag=`echo $pre_ip_addr | awk -F'::' '{print $1}'`
            if [ -z $location_flag ]
            then
                mid_ip_addr=${pre_ip_addr/::/0000:}
            else
                mid_ip_addr=${pre_ip_addr/::/:0000}
            fi
    ;;
        7) 
            location_flag_head=$(echo $pre_ip_addr | awk -F'::' '{print $1}')
            location_flag_end=$(echo $pre_ip_addr | awk -F'::' '{print $NF}')
            if [ -z $location_flag_head ]
            then 
                mid_ip_addr=${pre_ip_addr/::/0000:0000:}
            elif [ -z $location_flag_end ] 
            then
                mid_ip_addr=${pre_ip_addr/::/:0000:0000}
            else
                mid_ip_addr=${pre_ip_addr/::/:0000:}
            fi
        ;;
        6)
            location_flag_head=$(echo $pre_ip_addr | awk -F'::' '{print $1}')
            location_flag_end=$(echo $pre_ip_addr | awk -F'::' '{print $NF}')
            if [ -z $location_flag_head ]
            then 
                mid_ip_addr=${pre_ip_addr/::/0000:0000:0000:}
            elif [ -z $location_flag_end ] 
            then
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000}
            else
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:}
            fi
        
        ;;
        5)
            location_flag_head=$(echo $pre_ip_addr | awk -F'::' '{print $1}')
            location_flag_end=$(echo $pre_ip_addr | awk -F'::' '{print $NF}')
            if [ -z $location_flag_head ]
            then 
                mid_ip_addr=${pre_ip_addr/::/0000:0000:0000:0000:}
            elif [ -z $location_flag_end ] 
            then
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000:0000}
            else
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000:}
            fi
        ;;
        4)
            location_flag_head=$(echo $pre_ip_addr | awk -F'::' '{print $1}')
            location_flag_end=$(echo $pre_ip_addr | awk -F'::' '{print $NF}')
            if [ -z $location_flag_head ]
            then 
                mid_ip_addr=${pre_ip_addr/::/0000:0000:0000:0000:0000:}
            elif [ -z $location_flag_end ] 
            then
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000:0000:0000}
            else
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000:0000:}
            fi
        ;;
        3) 
            location_flag_head=$(echo $pre_ip_addr | awk -F'::' '{print $1}')
            location_flag_end=$(echo $pre_ip_addr | awk -F'::' '{print $NF}')
            if [ -z $location_flag_head ]
            then 
                mid_ip_addr=${pre_ip_addr/::/0000:0000:0000:0000:0000:0000:}
            elif [ -z $location_flag_end ] 
            then
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000:0000:0000:0000}
            else
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000:0000:0000:}
            fi
        ;;
        2) 
            location_flag_head=$(echo $pre_ip_addr | awk -F'::' '{print $1}')
            location_flag_end=$(echo $pre_ip_addr | awk -F'::' '{print $NF}')
            if [[ -z $location_flag_head && -z $location_flag_end ]]
            then
                mid_ip_addr=0000:0000:0000:0000:0000:0000:0000:0000
            elif [ -z $location_flag_head ]
            then 
                mid_ip_addr=${pre_ip_addr/::/0000:0000:0000:0000:0000:0000:0000:}
            elif [ -z $location_flag_end ] 
            then
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000:0000:0000:0000:0000}
            else 
                mid_ip_addr=${pre_ip_addr/::/:0000:0000:0000:0000:0000:0000:}
            fi
         ;;
    esac
    for((i=1;i<=8;i++));
    do 
        str=`echo $mid_ip_addr|awk -F ':' '{print $'$i'}'`
        str_len=`echo $mid_ip_addr|awk -F ':' '{print $'$i'}'|wc -L`
        if [ $i -eq 1 ]
        then
            if [ $str_len -eq 4 ]
            then
                str1=$str
            fi      
            if [ $str_len -eq 3 ]
            then
                str1=0${str}
            fi
            if [ $str_len -eq 2 ]
            then
                str1=00${str}
            fi
            if [ $str_len -eq 1 ]
            then 
                str1=000${str}
            fi
        fi
        if [ $i -eq 2 ]
        then
            if [ $str_len -eq 4 ]
            then
                str2=$str
            fi      
            if [ $str_len -eq 3 ]
            then
                str2=0${str}
            fi
            if [ $str_len -eq 2 ]
            then
                str2=00${str}
            fi
            if [ $str_len -eq 1 ]
            then 
                str2=000${str}
            fi
        fi
        if [ $i -eq 3 ]
        then
            if [ $str_len -eq 4 ]
            then
                str3=$str
            fi      
            if [ $str_len -eq 3 ]
            then
                str3=0${str}
            fi
            if [ $str_len -eq 2 ]
            then
                str3=00${str}
            fi
            if [ $str_len -eq 1 ]
            then 
                str3=000${str}
            fi
        fi
        if [ $i -eq 4 ]
        then
            if [ $str_len -eq 4 ]
            then
                str4=$str
            fi      
            if [ $str_len -eq 3 ]
            then
                str4=0${str}
            fi
            if [ $str_len -eq 2 ]
            then
                str4=00${str}
            fi
            if [ $str_len -eq 1 ]
            then 
                str4=000${str}
            fi
        fi
        if [ $i -eq 5 ]
        then
            if [ $str_len -eq 4 ]
            then
                str5=$str
            fi      
            if [ $str_len -eq 3 ]
            then
                str5=0${str}
            fi
            if [ $str_len -eq 2 ]
            then
                str5=00${str}
            fi
            if [ $str_len -eq 1 ]
            then 
                str5=000${str}
            fi
        fi
        if [ $i -eq 6 ]
        then
            if [ $str_len -eq 4 ]
            then
                str6=$str
            fi      
            if [ $str_len -eq 3 ]
            then
                str6=0${str}
            fi
            if [ $str_len -eq 2 ]
            then
                str6=00${str}
            fi
            if [ $str_len -eq 1 ]
            then 
                str6=000${str}
            fi
        fi
        if [ $i -eq 7 ]
        then
            if [ $str_len -eq 4 ]
            then
                str7=$str
            fi      
            if [ $str_len -eq 3 ]
            then
                str7=0${str}
            fi
            if [ $str_len -eq 2 ]
            then
                str7=00${str}
            fi
            if [ $str_len -eq 1 ]
            then 
                str7=000${str}
            fi
        fi
        if [ $i -eq 8 ]
        then
            if [ $str_len -eq 4 ]
            then
                str8=$str
            fi      
            if [ $str_len -eq 3 ]
            then
                str8=0${str}
            fi
            if [ $str_len -eq 2 ]
            then
                str8=00${str}
            fi
            if [ $str_len -eq 1 ]
            then 
                str8=000${str}
            fi
        fi
    done
    echo ${str1}:${str2}:${str3}:${str4}:${str5}:${str6}:${str7}:${str8}
}

function main()
{
    local L_OPERATOR=$1
    case "${L_OPERATOR}" in
        write_plane_config)
            write_ebackup_plane_config
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;

        kernel_check)
            suse_kernel_check
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                echo "suse kernel version is < 79."
                exit 1
            fi
            ;;
        rpm_check)
            necessary_rpm_check
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        rpm_install)
            necessary_rpm_install
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        get_pkg_name)
            output_pkg_name
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        get_upgrade_pkg_name)
            upgrade_pkg_name
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        get_plane_ip)
            output_plane_ip $2 $3
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        try_again_check)
            once_again_check
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        pre_install_check)
            pre_install_check
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        output_ibpkg_name)
            output_ibpkg_name
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        delete_ha_mode)
            delete_ha_mode
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        change_gaussdb_wait_time)
            change_gaussdb_wait_time
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        get_dmk_ipinfo)
            get_dmk_ipinfo
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        open_dmk2ebackup_iptables)
            open_dmk2ebackup_iptables $2
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        config_yum_repo)
            config_repo_server "$@"
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        print_route_info)
            print_route_info
            L_RET=$?
            if [ $L_RET -ne 0 ]
            then
                exit 1
            fi
            ;;
        *)
            ###usage            
            echo "Input arg command fail"
            exit 1
            ;;
        esac
}
if [ "X$2" == "Xipv6" ];then
    G_NETWORK_TYPE='ipv6'
elif [ "X$2" == "Xipv4" ] || [ "X$2" == "X" ];then
    G_NETWORK_TYPE='ipv4'
fi
main "$@"
exit $?
