# coding: utf-8
import os
import sys
import time

from hw_bcmanager_safe.commands import safe_subprocess

from common.common_define import CommonDefine
from common.logutils import Logger, AGENT_ASSIST_MANAGER_LOG
from common.utils import Utils

install_path = Utils.get_install_path()
log = Logger().get_logger(AGENT_ASSIST_MANAGER_LOG)


class AgentAssistStartProcess(object):

    def start_single_process(self, process_name):
        if Utils.check_process(process_name):
            log.info(f"{process_name} Process has already started.")
            return True

        file_path = os.path.join(install_path, 'AgentAssist', 'bin', 'assist', process_name)
        python_path = Utils.get_python_path()
        cmd = [python_path, file_path]
        try:
            if CommonDefine.IS_WINDOWS:
                safe_subprocess.Popen(cmd, creationflags=0x08000000)
            else:
                safe_subprocess.Popen(cmd)
            log.info(f"{process_name} is successfully started.")
            return True
        except Exception as err:
            log.error(f"Failed to start the {process_name} process. {err}")
            return False

    def run_process(self):
        if not self.start_single_process(Utils.monitor_file):
            log.error("Failed to start the monitor process.")
            return False
        return True

    def start_process(self):
        if not self.run_process():
            log.error("Failed to start process")
        # 考虑到某些机器进程拉起比较慢，于是在这里睡1秒，然后再去检查进程是否拉起，避免误判
        time.sleep(1)
        if Utils.check_process(Utils.monitor_file):
            log.info("The client assistant is started successfully.")
            return True
        else:
            log.error("Failed to start the client assistant.")
            return False


if __name__ == '__main__':
    start = AgentAssistStartProcess()
    if not start.start_process():
        sys.exit(1)
    sys.exit(0)
