import os
import time
from threading import Thread

from common.common_define import Permission
from common.utils import Utils
from message.tcp.agentframework import Client
from message.tcp.common import func_map, msg_queue, logger
from message.tcp.messageparser import MessageParser, CMD_TYPE_CONST

SLEEP_TIME_SEC = 1
CMD_TYPE_STEP = 1
SEQ_NUM_STEP = 1


class ClientManager(object):
    def __init__(self):
        """
        create send recv thread for send/recv message
        """
        self._send_exit_flag = False
        self._recv_exit_flag = False
        self.client = Client()
        self.t_send = Thread(target=self.send_message)
        self.t_recv = Thread(target=self.recv_message)
        self.t_send.start()
        self.t_recv.start()

    def __del__(self):
        self._send_exit_flag = True
        self._recv_exit_flag = True

    def connect(self):
        self.client.connect()

    def disconnect(self):
        self.client.disconnect(self.client.ssl_sock)

    def send_message(self):
        while not self._send_exit_flag:
            msg = msg_queue.pop_rsp()
            self.client.send_msg(msg)
            time.sleep(SLEEP_TIME_SEC)

    def recv_message(self):
        while not self._recv_exit_flag:
            if msg_queue.is_req_empty():
                time.sleep(SLEEP_TIME_SEC)
                continue
            msg = msg_queue.pop_req()
            cmd_type = msg[0].get("cmd_type")
            if not func_map.is_exist_cmd(cmd_type):
                logger.info(f"Can not find cmd_type:{cmd_type} handle function, ignore.")
            else:
                func = func_map.get_action(cmd_type)
                func_ret = func(msg)
                if func_ret is not None and not isinstance(func_ret, bool):
                    body_bytes = MessageParser.to_bytes(func_ret)
                else:
                    body_bytes = b''

                # 组装响应proxy消息：
                if cmd_type != CMD_TYPE_CONST["update_cipher_type"]:
                    cmd_type += CMD_TYPE_STEP
                    sequence_num = msg[0].get("sequence_num") + SEQ_NUM_STEP
                    msg_head = MessageParser.make_msg_head(cmd_type, sequence_num, body_bytes)
                    msg_head_pack = MessageParser.pack_msg_head(*msg_head)
                    messages = msg_head_pack + body_bytes
                    msg_queue.push_rsp(messages)
            time.sleep(SLEEP_TIME_SEC)

    def start_recv_msg(self):
        self.client.start_recv_msg()

    def chmod_log(self):
        kmc_logpath = os.path.join('/opt/huawei/agentassist/kmc/log', 'kmc.log')
        adapter_logpath = os.path.join('/opt/huawei/agentassist/kmc/log', 'adapter.log')
        try:
            Utils.mod_chmod(kmc_logpath, Permission.PERMISSION_600)
            Utils.mod_chmod(adapter_logpath, Permission.PERMISSION_600)
        except Exception as e:
            logger.error(f"Set kmc.log and adapter.log permission fail {e}.")


def main():
    manager = ClientManager()
    manager.connect()
    manager.chmod_log()
    # 收消息
    t_recv_msg = Thread(target=manager.start_recv_msg)
    t_recv_msg.start()
