from threading import Lock

from message.tcp.cdecorator import singleton


@singleton
class FuncMap(object):
    def __init__(self):
        self._func_map = {}
        self._func_map_lock = Lock()

    def add_action(self, cmd, call_func):
        with self._func_map_lock:
            if cmd not in self._func_map:
                self._func_map[cmd] = call_func

    def clear_all_action(self):
        with self._func_map_lock:
            self._func_map.clear()

    def del_action(self, cmd):
        with self._func_map_lock:
            if cmd in self._func_map:
                del self._func_map[cmd]

    def is_exist_cmd(self, cmd):
        return cmd in self._func_map

    def get_action(self, cmd):
        return self._func_map.get(cmd)
